/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DocumentsSizeUpdater
extends AbstractQuotaStatsUpdater {
    private static Logger log = LogManager.getLogger(DocumentsSizeUpdater.class);
    public static final String DISABLE_QUOTA_CHECK_LISTENER = "disableQuotaListener";
    public static final String USER_WORKSPACES_ROOT = "UserWorkspacesRoot";
    public static final String CLEAR_SCROLL_SIZE_PROP = "nuxeo.quota.clear.scroll.size";
    public static final int DEFAULT_CLEAR_SCROLL_SIZE = 500;
    public static final String CLEAR_SCROLL_KEEP_ALIVE_PROP = "nuxeo.quota.clear.scroll.keepAliveSeconds";
    public static final int DEFAULT_CLEAR_SCROLL_KEEP_ALIVE = 60;
    public static final String INIT_SCROLL_SIZE_PROP = "nuxeo.quota.init.scroll.size";
    public static final int DEFAULT_INIT_SCROLL_SIZE = 250;
    public static final String INIT_SCROLL_KEEP_ALIVE_PROP = "nuxeo.quota.init.scroll.keepAliveSeconds";
    public static final int DEFAULT_INIT_SCROLL_KEEP_ALIVE = 120;

    @Override
    public void computeInitialStatistics(CoreSession session, QuotaStatsInitialWork currentWorker, String path) {
        DocumentModel root;
        log.debug("Starting initial Quota computation for path: {}", (Object)path);
        Object query = "SELECT ecm:uuid FROM Document WHERE ecm:isVersion = 0 AND ecm:isProxy = 0";
        if (path == null) {
            root = session.getRootDocument();
        } else {
            root = session.getDocument((DocumentRef)new PathRef(path));
            query = (String)query + " AND ecm:path STARTSWITH " + NXQL.escapeString((String)path);
        }
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        int clearScrollSize = confService.getInteger(CLEAR_SCROLL_SIZE_PROP, 500);
        int clearScrollKeepAlive = confService.getInteger(CLEAR_SCROLL_KEEP_ALIVE_PROP, 60);
        int initScrollSize = confService.getInteger(INIT_SCROLL_SIZE_PROP, 250);
        int initScrollKeepAlive = confService.getInteger(INIT_SCROLL_KEEP_ALIVE_PROP, 120);
        log.debug("Start scrolling to clear quotas");
        long clearCount = this.scrollAndDo(session, (String)query, clearScrollSize, clearScrollKeepAlive, (uuid, idx) -> this.clearQuotas(session, (String)uuid));
        log.debug("End scrolling to clear quotas, documentCount={}", (Object)clearCount);
        this.clearQuotas(session, root.getId());
        session.save();
        log.debug("Start scrolling to init quotas");
        long initCount = this.scrollAndDo(session, (String)query, initScrollSize, initScrollKeepAlive, (uuid, idx) -> {
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(uuid));
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("process Quota initial computation on uuid={}", supplierArray);
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = () -> ((DocumentModel)doc).getId();
            log.trace("doc with uuid {} started update", supplierArray2);
            this.initDocument(session, doc);
            Supplier[] supplierArray3 = new Supplier[1];
            supplierArray3[0] = () -> ((DocumentModel)doc).getId();
            log.trace("doc with uuid {} update completed", supplierArray3);
            currentWorker.notifyProgress((long)idx, clearCount);
        });
        log.debug("End scrolling to init quotas, documentCount={}", (Object)initCount);
        if (path != null) {
            DocumentModel doc = root;
            do {
                doc = session.getDocument(doc.getParentRef());
                this.initDocumentFromChildren(doc);
            } while (!doc.getPathAsString().equals("/"));
        }
    }

    protected long scrollAndDo(CoreSession session, String query, int scrollSize, int scrollKeepAlive, BiConsumer<String, Long> consumer) {
        long count = 0L;
        ScrollResult scroll = session.scroll(query, scrollSize, scrollKeepAlive);
        while (scroll.hasResults()) {
            for (String uuid : scroll.getResults()) {
                consumer.accept(uuid, ++count);
            }
            session.save();
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            scroll = session.scroll(scroll.getScrollId());
        }
        return count;
    }

    protected void clearQuotas(CoreSession session, String docID) {
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docID));
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            quotaDoc.clearInfos();
            quotaDoc.save();
        }
    }

    protected void initDocument(CoreSession session, DocumentModel doc) {
        boolean isDeleted = doc.isTrashed();
        long size = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        this.updateDocumentAndAncestors(session, doc, size, size + versionsSize, isDeleted ? size : 0L, versionsSize);
    }

    protected void initDocumentFromChildren(DocumentModel doc) {
        CoreSession session = doc.getCoreSession();
        boolean isDeleted = doc.isTrashed();
        long innerSize = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        long totalSize = innerSize + versionsSize;
        long trashSize = isDeleted ? innerSize : 0L;
        for (DocumentModel child : session.getChildren(doc.getRef())) {
            QuotaAware quotaDoc = (QuotaAware)child.getAdapter(QuotaAware.class);
            if (quotaDoc == null) continue;
            totalSize += quotaDoc.getTotalSize();
            trashSize += quotaDoc.getTrashSize();
            versionsSize += quotaDoc.getVersionsSize();
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
        }
        quotaDoc.setAll(innerSize, totalSize, trashSize, versionsSize);
        quotaDoc.save();
    }

    @Override
    protected void handleQuotaExceeded(QuotaExceededException e, Event event) {
        String msg = "Current event " + event.getName() + " would break Quota restriction, rolling back";
        log.info(msg);
        e.addInfo(msg);
        event.markRollBack("Quota Exceeded", (Exception)((Object)e));
    }

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel doc) {
        if (doc.isVersion()) {
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
            quotaDoc.save();
        }
        long size = this.getBlobsSize(doc);
        this.checkQuota(session, doc, size);
        this.updateDocumentAndAncestors(session, doc, size, size, 0L, 0L);
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentBeforeCheckedIn(CoreSession session, DocumentModel doc) {
        long size = this.getBlobsSize(doc);
        this.checkQuota(session, doc, size);
        boolean allowSave = doc.getContextData().containsKey("VersioningOption");
        this.updateDocument(doc, 0L, size, 0L, size, allowSave);
        this.updateAncestors(session, doc, size, 0L, size);
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentBeforeCheckedOut(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        long oldSize = quotaDoc == null ? 0L : quotaDoc.getInnerSize();
        long delta = this.getBlobsSize(doc) - oldSize;
        this.checkQuota(session, doc, delta);
        this.updateDocument(doc, delta, delta, 0L, 0L, false);
        this.updateAncestors(session, doc, delta, 0L, 0L);
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getTotalSize() - quotaDoc.getVersionsSize() - quotaDoc.getTrashSize();
        this.checkQuota(session, doc, size);
        if (!doc.isFolder() && size > 0L) {
            quotaDoc.resetInfos();
            quotaDoc.save();
            this.updateDocument(doc, size, size, 0L, 0L);
        }
        this.updateAncestors(session, doc, size, 0L, 0L);
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel doc, DocumentModel sourceParent) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        long size = quotaDoc == null ? 0L : quotaDoc.getTotalSize();
        this.checkQuota(session, doc, size);
        long versionsSize = quotaDoc == null ? 0L : quotaDoc.getVersionsSize();
        this.updateAncestors(session, doc, size, 0L, versionsSize);
        if (sourceParent != null) {
            this.updateDocumentAndAncestors(session, sourceParent, 0L, -size, 0L, -versionsSize);
        }
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel doc) {
        long versionsSize;
        long size;
        if (doc.isVersion()) {
            long size2 = this.getBlobsSize(doc);
            String sourceId = doc.getSourceId();
            if (size2 > 0L && sourceId != null) {
                DocumentModel liveDoc = session.getDocument((DocumentRef)new IdRef(sourceId));
                this.updateDocumentAndAncestors(session, liveDoc, 0L, -size2, 0L, -size2);
            }
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            size = this.getBlobsSize(doc);
            versionsSize = 0L;
            log.trace("Document {} doesn't have the facet quotaDoc. Compute impacted size: {}", (Object)doc.getId(), (Object)size);
        } else {
            size = quotaDoc.getTotalSize();
            versionsSize = quotaDoc.getVersionsSize();
            log.trace("Found facet quotaDoc on document  {}. Total size: {} and versions size: {}", (Object)doc.getId(), (Object)size, (Object)versionsSize);
        }
        boolean isDeleted = doc.isTrashed();
        log.trace("Processing document about to be removed on parents. Total: {}, trash size: {}, versions size: ", (Object)size, (Object)(isDeleted ? size : 0L), (Object)versionsSize);
        long deltaTrash = isDeleted ? versionsSize - size : 0L;
        this.updateAncestors(session, doc, -size, deltaTrash, -versionsSize);
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, boolean isTrashed) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getInnerSize();
        if (log.isTraceEnabled() && quotaDoc.getDoc().isFolder()) {
            log.trace(quotaDoc.getDoc().getPathAsString() + " is a folder, just inner size (" + size + ") taken into account for trash size");
        }
        long delta = isTrashed ? size : -size;
        this.updateDocumentAndAncestors(session, doc, 0L, 0L, delta, 0L);
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getTotalSize();
        long versionsSize = quotaDoc.getVersionsSize();
        this.updateAncestors(session, doc, -size, 0L, -versionsSize);
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = QuotaAwareDocumentFactory.make(doc);
        quotaDoc.resetInfos();
        quotaDoc.save();
        long size = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        this.updateDocumentAndAncestors(session, doc, size, size + versionsSize, 0L, versionsSize);
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        if (doc.isProxy()) {
            return false;
        }
        return !Boolean.TRUE.equals(doc.getContextData(DISABLE_QUOTA_CHECK_LISTENER));
    }

    protected void checkQuota(CoreSession session, DocumentModel doc, long delta) {
        if (delta <= 0L) {
            return;
        }
        for (DocumentModel parent : this.getAncestors(session, doc)) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)parent).getId();
            supplierArray[1] = () -> ((DocumentModel)parent).getPathAsString();
            log.trace("processing {} {}", supplierArray);
            QuotaAware quotaDoc = (QuotaAware)parent.getAdapter(QuotaAware.class);
            if (quotaDoc == null || quotaDoc.getMaxQuota() <= 0L || USER_WORKSPACES_ROOT.equals(parent.getType()) || quotaDoc.getTotalSize() + delta <= quotaDoc.getMaxQuota()) continue;
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = () -> ((DocumentModel)doc).getId();
            supplierArray2[1] = () -> ((DocumentModel)doc).getPathAsString();
            log.info("Raising Quota Exception on {} ({})", supplierArray2);
            throw new QuotaExceededException(parent, doc, quotaDoc.getMaxQuota());
        }
    }

    protected long getVersionsSize(CoreSession session, DocumentModel doc) {
        long versionsSize = 0L;
        for (DocumentModel version : session.getVersions(doc.getRef())) {
            versionsSize += this.getBlobsSize(version);
        }
        return versionsSize;
    }

    protected long getBlobsSize(DocumentModel doc) {
        long size = 0L;
        for (Blob blob : this.getAllBlobs(doc)) {
            size += blob.getLength();
        }
        return size;
    }

    protected List<Blob> getAllBlobs(DocumentModel doc) {
        QuotaSizeService sizeService = (QuotaSizeService)Framework.getService(QuotaSizeService.class);
        Collection<String> excludedPaths = sizeService.getExcludedPathList();
        BlobsExtractor extractor = new BlobsExtractor();
        extractor.setExtractorProperties(null, new HashSet<String>(excludedPaths), true);
        return extractor.getBlobs(doc);
    }

    protected void updateDocument(DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions) {
        this.updateDocument(doc, deltaInner, deltaTotal, deltaTrash, deltaVersions, true);
    }

    protected void updateDocument(DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions, boolean allowSave) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        boolean save = false;
        if (quotaDoc == null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> ((DocumentModel)doc).getPathAsString();
            log.trace("   add quota on: {} ({})", supplierArray);
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
            save = true;
        } else {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[2] = quotaDoc::getQuotaInfo;
            log.trace("   update quota on: {} ({}) ({})", supplierArray);
        }
        if (deltaInner != 0L) {
            quotaDoc.addInnerSize(deltaInner);
            save = true;
        }
        if (deltaTotal != 0L) {
            quotaDoc.addTotalSize(deltaTotal);
            save = true;
        }
        if (deltaTrash != 0L) {
            quotaDoc.addTrashSize(deltaTrash);
            save = true;
        }
        if (deltaVersions != 0L) {
            quotaDoc.addVersionsSize(deltaVersions);
            save = true;
        }
        if (save && allowSave) {
            quotaDoc.save();
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((DocumentModel)doc).getId();
        supplierArray[1] = () -> ((DocumentModel)doc).getPathAsString();
        supplierArray[2] = quotaDoc::getQuotaInfo;
        log.trace("     ==> {} ({}) ({})", supplierArray);
    }

    protected void updateAncestors(CoreSession session, DocumentModel doc, long deltaTotal, long deltaTrash, long deltaVersions) {
        if (deltaTotal == 0L && deltaTrash == 0L && deltaVersions == 0L) {
            return;
        }
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        for (DocumentModel ancestor : ancestors) {
            this.updateDocument(ancestor, 0L, deltaTotal, deltaTrash, deltaVersions);
        }
    }

    protected void updateDocumentAndAncestors(CoreSession session, DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions) {
        this.updateDocument(doc, deltaInner, deltaTotal, deltaTrash, deltaVersions);
        this.updateAncestors(session, doc, deltaTotal, deltaTrash, deltaVersions);
    }
}

