/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.quota.size.BlobExcludeDescriptor;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class QuotaSizeServiceImpl
extends DefaultComponent
implements QuotaSizeService {
    private Set<String> excludedPathList = new HashSet<String>();
    private static final Logger log = LogManager.getLogger(QuotaSizeServiceImpl.class);

    @Override
    public Collection<String> getExcludedPathList() {
        return this.excludedPathList;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("exclusions".equals(extensionPoint)) {
            BlobExcludeDescriptor descriptor = (BlobExcludeDescriptor)contribution;
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = descriptor::getPathRegexp;
            log.info("Adding: {} to size quota computation's blacklist", supplierArray);
            this.excludedPathList.add(descriptor.getPathRegexp());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        BlobExcludeDescriptor descriptor;
        String pathRegexp;
        if ("exclusions".equals(extensionPoint) && this.excludedPathList.contains(pathRegexp = (descriptor = (BlobExcludeDescriptor)contribution).getPathRegexp())) {
            log.info("Removing: {} from size quota computation's blacklist", (Object)pathRegexp);
            this.excludedPathList.remove(pathRegexp);
        }
    }
}

