/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.size.BlobSizeInfo;

public class SizeUpdateEventContext
extends DocumentEventContext {
    public static final String QUOTA_UPDATE_NEEDED = "quotaUpdateNeeded";
    public static final String DOCUMENT_UPDATE_INITIAL_STATISTICS = "documentUpdateInitialStats";
    private static final long serialVersionUID = 1L;
    public static final String BLOB_SIZE_PROPERTY_KEY = "blobSize";
    public static final String BLOB_DELTA_PROPERTY_KEY = "blobDelta";
    public static final String VERSIONS_SIZE_PROPERTY_KEY = "versionsSize";
    public static final String VERSIONS_SIZE_ON_TOTAL_PROPERTY_KEY = "versionsSizeOnTotal";
    public static final String PARENT_UUIDS_PROPERTY_KEY = "parentUUIDs";
    public static final String SOURCE_EVENT_PROPERTY_KEY = "sourceEvent";
    public static final String MARKER_KEY = "contextType";
    public static final String MARKER_VALUE = "SizeUpdateEventContext";
    public static final String _UPDATE_TRASH_SIZE = "_UPDATE_TRASH";

    protected SizeUpdateEventContext(CoreSession session, DocumentEventContext evtCtx) {
        super(session, evtCtx.getPrincipal(), evtCtx.getSourceDocument(), evtCtx.getDestination());
        this.setProperty(MARKER_KEY, (Serializable)((Object)MARKER_VALUE));
    }

    public SizeUpdateEventContext(CoreSession session, DocumentEventContext evtCtx, DocumentModel sourceDocument, BlobSizeInfo bsi, String sourceEvent) {
        super(session, evtCtx.getPrincipal(), sourceDocument, evtCtx.getDestination());
        this.setBlobSize(bsi.getBlobSize());
        this.setBlobDelta(bsi.getBlobSizeDelta());
        this.setProperty(SOURCE_EVENT_PROPERTY_KEY, (Serializable)((Object)sourceEvent));
        this.setProperty(MARKER_KEY, (Serializable)((Object)MARKER_VALUE));
    }

    public SizeUpdateEventContext(CoreSession session, BlobSizeInfo bsi, String sourceEvent, DocumentModel sourceDocument) {
        super(session, session.getPrincipal(), sourceDocument, null);
        this.setBlobSize(bsi.getBlobSize());
        this.setBlobDelta(bsi.getBlobSizeDelta());
        this.setProperty(SOURCE_EVENT_PROPERTY_KEY, (Serializable)((Object)sourceEvent));
        this.setProperty(MARKER_KEY, (Serializable)((Object)MARKER_VALUE));
    }

    public SizeUpdateEventContext(CoreSession session, DocumentEventContext evtCtx, BlobSizeInfo bsi, String sourceEvent) {
        super(session, evtCtx.getPrincipal(), evtCtx.getSourceDocument(), evtCtx.getDestination());
        this.setBlobSize(bsi.getBlobSize());
        this.setBlobDelta(bsi.getBlobSizeDelta());
        this.setProperty(SOURCE_EVENT_PROPERTY_KEY, (Serializable)((Object)sourceEvent));
        this.setProperty(MARKER_KEY, (Serializable)((Object)MARKER_VALUE));
    }

    public SizeUpdateEventContext(CoreSession session, DocumentEventContext evtCtx, long totalSize, String sourceEvent) {
        super(session, evtCtx.getPrincipal(), evtCtx.getSourceDocument(), evtCtx.getDestination());
        this.setBlobSize(totalSize);
        this.setBlobDelta(-totalSize);
        this.setProperty(SOURCE_EVENT_PROPERTY_KEY, (Serializable)((Object)sourceEvent));
        this.setProperty(MARKER_KEY, (Serializable)((Object)MARKER_VALUE));
    }

    public static SizeUpdateEventContext unwrap(DocumentEventContext docCtx) {
        if (MARKER_VALUE.equals(docCtx.getProperty(MARKER_KEY))) {
            SizeUpdateEventContext ctx = new SizeUpdateEventContext(docCtx.getCoreSession(), docCtx);
            ctx.setProperties(docCtx.getProperties());
            return ctx;
        }
        return null;
    }

    public long getBlobSize() {
        return (Long)this.getProperty(BLOB_SIZE_PROPERTY_KEY);
    }

    public void setBlobSize(long blobSize) {
        this.setProperty(BLOB_SIZE_PROPERTY_KEY, new Long(blobSize));
    }

    public void setVersionsSize(long versionsSize) {
        this.setProperty(VERSIONS_SIZE_PROPERTY_KEY, new Long(versionsSize));
    }

    public long getVersionsSize() {
        if (this.getProperty(VERSIONS_SIZE_PROPERTY_KEY) != null) {
            return (Long)this.getProperty(VERSIONS_SIZE_PROPERTY_KEY);
        }
        return 0L;
    }

    public void setVersionsSizeOnTotal(long blobSize) {
        this.setProperty(VERSIONS_SIZE_ON_TOTAL_PROPERTY_KEY, Long.valueOf(blobSize));
    }

    public long getVersionsSizeOnTotal() {
        if (this.getProperty(VERSIONS_SIZE_ON_TOTAL_PROPERTY_KEY) != null) {
            return (Long)this.getProperty(VERSIONS_SIZE_ON_TOTAL_PROPERTY_KEY);
        }
        return 0L;
    }

    public long getBlobDelta() {
        return (Long)this.getProperty(BLOB_DELTA_PROPERTY_KEY);
    }

    public void setBlobDelta(long blobDelta) {
        this.setProperty(BLOB_DELTA_PROPERTY_KEY, new Long(blobDelta));
    }

    public List<String> getParentUUIds() {
        return (List)((Object)this.getProperty(PARENT_UUIDS_PROPERTY_KEY));
    }

    public void setParentUUIds(List<String> parentUUIds) {
        parentUUIds.removeAll(Collections.singleton(null));
        this.setProperty(PARENT_UUIDS_PROPERTY_KEY, (Serializable)((Object)parentUUIds));
    }

    public String getSourceEvent() {
        return (String)((Object)this.getProperty(SOURCE_EVENT_PROPERTY_KEY));
    }

    public long getTrashSize() {
        if (this.getProperty(_UPDATE_TRASH_SIZE) != null && ((Boolean)this.getProperty(_UPDATE_TRASH_SIZE)).booleanValue()) {
            return this.getBlobSize();
        }
        return 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CoreSession " + this.getCoreSession().getSessionId());
        sb.append("\nsourceDocument " + this.getSourceDocument().getId() + " " + this.getSourceDocument().getPathAsString());
        sb.append("\nprops " + this.getProperties().toString());
        return sb.toString();
    }

    public Event newQuotaUpdateEvent() {
        return this.newEvent(QUOTA_UPDATE_NEEDED);
    }
}

