/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.runtime.api.Framework;

public class QuotaStatsListener
implements EventListener {
    public static final Set<String> EVENTS_TO_HANDLE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("documentCreated", "documentCreatedByCopy", "documentModified", "documentMoved", "aboutToRemove", "beforeDocumentModification", "aboutToRemoveVersion", "documentCheckedIn", "documentCheckedOut", "lifecycle_transition_event", "beforeRestoringDocument", "documentRestored")));

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        if (!EVENTS_TO_HANDLE.contains(event.getName())) {
            return;
        }
        if ("lifecycle_transition_event".equals(event.getName()) && !this.isTrashOpEvent((DocumentEventContext)ctx)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        quotaStatsService.updateStatistics(docCtx, event);
    }

    protected boolean isTrashOpEvent(DocumentEventContext eventContext) {
        String transition = (String)eventContext.getProperties().get("transition");
        return transition != null && ("delete".equals(transition) || "undelete".equals(transition));
    }
}

