/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocument;

public class QuotaAwareDocumentFactory
implements DocumentAdapterFactory {
    public static QuotaAwareDocument make(DocumentModel doc, boolean save) throws ClientException {
        if (!doc.hasFacet("DocumentsSizeStatistics")) {
            doc.addFacet("DocumentsSizeStatistics");
            if (save) {
                doc.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
                doc.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                doc = doc.getCoreSession().saveDocument(doc);
            }
        }
        return (QuotaAwareDocument)doc.getAdapter(QuotaAware.class);
    }

    public Object getAdapter(DocumentModel doc, Class<?> adapter) {
        if (doc.hasFacet("DocumentsSizeStatistics")) {
            return adapter.cast(new QuotaAwareDocument(doc));
        }
        return null;
    }
}

