/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.SizeUpdateEventContext;

public class QuotaComputerProcessor
implements PostCommitEventListener {
    protected static final Log log = LogFactory.getLog(QuotaComputerProcessor.class);

    public void handleEvent(EventBundle eventBundle) throws ClientException {
        if (eventBundle.containsEventName("quotaUpdateNeeded")) {
            for (Event event : eventBundle) {
                SizeUpdateEventContext quotaCtx;
                EventContext ctx;
                if (!event.getName().equals("quotaUpdateNeeded") || !((ctx = event.getContext()) instanceof DocumentEventContext)) continue;
                if (log.isTraceEnabled()) {
                    String sid = ((DocumentEventContext)ctx).getCoreSession().getSessionId();
                    log.trace((Object)("Orginal SessionId:" + sid));
                }
                if ((quotaCtx = SizeUpdateEventContext.unwrap((DocumentEventContext)ctx)) == null) continue;
                this.processQuotaComputation(quotaCtx);
                this.debugCheck(quotaCtx);
            }
        }
    }

    protected void debugCheck(SizeUpdateEventContext quotaCtx) throws ClientException {
        DocumentModel sourceDocument;
        String sourceEvent = quotaCtx.getSourceEvent();
        CoreSession session = quotaCtx.getCoreSession();
        if (session.exists((sourceDocument = quotaCtx.getSourceDocument()).getRef())) {
            DocumentModel doc = session.getDocument(sourceDocument.getRef());
            if (log.isTraceEnabled()) {
                if (doc.hasFacet("DocumentsSizeStatistics")) {
                    log.trace((Object)"Double Check Facet was added OK");
                } else {
                    log.trace((Object)"No facet !!!!");
                }
            }
        } else {
            log.debug((Object)("Document " + sourceDocument.getRef() + " no longer exists (" + sourceEvent + ")"));
        }
    }

    public void processQuotaComputation(SizeUpdateEventContext quotaCtx) throws ClientException {
        String sourceEvent = quotaCtx.getSourceEvent();
        CoreSession session = quotaCtx.getCoreSession();
        DocumentModel sourceDocument = quotaCtx.getSourceDocument();
        if (sourceDocument instanceof ShallowDocumentModel) {
            if (!"aboutToRemove".equals(sourceEvent) && !"aboutToRemoveVersion".equals(sourceEvent)) {
                log.error((Object)("Unable to reconnect Document " + sourceDocument.getPathAsString() + " on event " + sourceEvent));
                return;
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("sourceDoc SessionId:" + sourceDocument.getSessionId()));
            log.trace((Object)("sourceDoc SessionId:" + sourceDocument.getCoreSession().getSessionId()));
        }
        ArrayList<DocumentModel> parents = new ArrayList<DocumentModel>();
        log.debug((Object)("compute Quota on " + sourceDocument.getPathAsString() + " and parents"));
        if ("aboutToRemove".equals(sourceEvent) || "aboutToRemoveVersion".equals(sourceEvent)) {
            for (String id : quotaCtx.getParentUUIds()) {
                if (!session.exists((DocumentRef)new IdRef(id))) continue;
                parents.add(session.getDocument((DocumentRef)new IdRef(id)));
            }
        } else if ("documentMoved".equals(sourceEvent)) {
            if (quotaCtx.getParentUUIds() != null && quotaCtx.getParentUUIds().size() > 0) {
                for (String id : quotaCtx.getParentUUIds()) {
                    if (!session.exists((DocumentRef)new IdRef(id))) continue;
                    parents.add(session.getDocument((DocumentRef)new IdRef(id)));
                }
            } else {
                parents.addAll(this.getParents(sourceDocument, session));
            }
        } else {
            if ((sourceDocument = session.getDocument(sourceDocument.getRef())).getRef() == null) {
                log.error((Object)"SourceDocument has no ref");
            } else {
                parents.addAll(this.getParents(sourceDocument, session));
            }
            QuotaAware quotaDoc = (QuotaAware)sourceDocument.getAdapter(QuotaAware.class);
            if (!"documentCreatedByCopy".equals(sourceEvent)) {
                if (quotaDoc == null) {
                    log.debug((Object)("  add Quota Facet on " + sourceDocument.getPathAsString()));
                    quotaDoc = QuotaAwareDocumentFactory.make(sourceDocument, false);
                } else {
                    log.debug((Object)("  update Quota Facet on " + sourceDocument.getPathAsString()));
                }
                if ("documentCheckedIn".equals(sourceEvent)) {
                    long versionSize = this.getVersionSizeFromCtx(quotaCtx);
                    quotaDoc.addVersionsSize(versionSize, false);
                    quotaDoc.addTotalSize(versionSize, true);
                } else if (!"documentCheckedOut".equals(sourceEvent)) {
                    if ("delete".equals(sourceEvent) || "undelete".equals(sourceEvent)) {
                        quotaDoc.addTrashSize(quotaCtx.getBlobSize(), true);
                    } else if ("documentUpdateInitialStats".equals(sourceEvent)) {
                        quotaDoc.addInnerSize(quotaCtx.getBlobSize(), false);
                        quotaDoc.addTotalSize(quotaCtx.getVersionsSizeOnTotal(), false);
                        quotaDoc.addTrashSize(quotaCtx.getTrashSize(), false);
                        quotaDoc.addVersionsSize(quotaCtx.getVersionsSize(), true);
                    } else {
                        quotaDoc.addInnerSize(quotaCtx.getBlobDelta(), true);
                    }
                }
            } else if (!sourceDocument.isFolder()) {
                quotaDoc.resetInfos(false);
                quotaDoc.addInnerSize(quotaCtx.getBlobSize(), true);
            }
        }
        if (parents.size() > 0) {
            if ("documentCheckedIn".equals(sourceEvent)) {
                long versionSize = this.getVersionSizeFromCtx(quotaCtx);
                this.processOnParents(parents, versionSize, 0L, versionSize, true, false, true);
            } else if (!"documentCheckedOut".equals(sourceEvent)) {
                if ("delete".equals(sourceEvent) || "undelete".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobSize(), quotaCtx.getTrashSize(), false, true);
                } else if ("aboutToRemoveVersion".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), 0L, quotaCtx.getBlobDelta(), true, false, true);
                } else if ("aboutToRemove".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), quotaCtx.getTrashSize(), quotaCtx.getVersionsSize(), true, quotaCtx.getProperties().get("_UPDATE_TRASH") != null && (Boolean)quotaCtx.getProperties().get("_UPDATE_TRASH") != false, true);
                } else if ("documentMoved".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), 0L, quotaCtx.getVersionsSize(), true, false, true);
                } else if ("documentUpdateInitialStats".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobSize() + quotaCtx.getVersionsSizeOnTotal(), quotaCtx.getTrashSize(), quotaCtx.getVersionsSize(), true, quotaCtx.getProperties().get("_UPDATE_TRASH") != null && (Boolean)quotaCtx.getProperties().get("_UPDATE_TRASH") != false, true);
                } else if ("documentCreatedByCopy".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobSize(), 0L, true, false);
                } else {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), quotaCtx.getBlobDelta(), true, false);
                }
            }
        }
    }

    private long getVersionSizeFromCtx(SizeUpdateEventContext quotaCtx) {
        return quotaCtx.getBlobSize() - quotaCtx.getBlobDelta();
    }

    protected void processOnParents(List<DocumentModel> parents, long delta, long trash, boolean total, boolean trashOp) throws ClientException {
        this.processOnParents(parents, delta, trash, 0L, total, trashOp, false);
    }

    protected void processOnParents(List<DocumentModel> parents, long deltaTotal, long trashSize, long deltaVersions, boolean total, boolean trashOp, boolean versionsOp) throws ClientException {
        for (DocumentModel parent : parents) {
            QuotaAware quotaDoc = (QuotaAware)parent.getAdapter(QuotaAware.class);
            if (quotaDoc == null) {
                log.debug((Object)("   add Quota Facet on parent " + parent.getPathAsString()));
                quotaDoc = QuotaAwareDocumentFactory.make(parent, false);
            } else {
                log.debug((Object)("   update Quota Facet on parent " + parent.getPathAsString()));
            }
            if (total) {
                quotaDoc.addTotalSize(deltaTotal, true);
            }
            if (trashOp) {
                quotaDoc.addTrashSize(deltaTotal, true);
            }
            if (!versionsOp) continue;
            quotaDoc.addVersionsSize(deltaVersions, true);
        }
    }

    protected List<DocumentModel> getParents(DocumentModel sourceDocument, CoreSession session) throws ClientException {
        DocumentRef[] parentRefs;
        ArrayList<DocumentModel> parents = new ArrayList<DocumentModel>();
        for (DocumentRef documentRef : parentRefs = session.getParentDocumentRefs(sourceDocument.getRef())) {
            parents.add(session.getDocument(documentRef));
        }
        return parents;
    }
}

