/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;

public class QuotaUserWorkspaceListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        if (!"userWorkspaceCreated".equals(event.getName())) {
            return;
        }
        DocumentModel userWorkspace = ((DocumentEventContext)ctx).getSourceDocument();
        CoreSession session = userWorkspace.getCoreSession();
        DocumentModel userWorkspacesRoot = session.getDocument(userWorkspace.getParentRef());
        if (userWorkspacesRoot == null || !"UserWorkspacesRoot".equals(userWorkspacesRoot.getType())) {
            return;
        }
        QuotaAware qaUserWorkspaces = (QuotaAware)userWorkspacesRoot.getAdapter(QuotaAware.class);
        if (qaUserWorkspaces == null || qaUserWorkspaces.getMaxQuota() == -1L) {
            return;
        }
        QuotaAware qa = (QuotaAware)userWorkspace.getAdapter(QuotaAware.class);
        if (qa == null) {
            qa = QuotaAwareDocumentFactory.make(userWorkspace, false);
        }
        qa.setMaxQuota(qaUserWorkspaces.getMaxQuota(), true, true);
    }
}

