/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.text.DecimalFormat;

public class QuotaDisplayValue {
    protected static final long KB_LIMIT = 1024L;
    protected static final long MB_LIMIT = 0x100000L;
    protected static final long GB_LIMIT = 0x40000000L;
    public static final String GB_UNIT = "label.unit.GB";
    public static final String MB_UNIT = "label.unit.MB";
    public static final String KB_UNIT = "label.unit.KB";
    public static final String UNLIMITED_VALUE = "label.unit.unlimited.value";
    protected final long value;
    protected float valueInUnit;
    protected String unit;
    protected long max;

    public QuotaDisplayValue(long value) {
        this.value = value;
        this.init();
    }

    public QuotaDisplayValue(long value, long max) {
        this(value);
        this.max = max;
    }

    protected void init() {
        if (this.value < 0L) {
            this.unit = UNLIMITED_VALUE;
            this.valueInUnit = 0.0f;
        } else if (this.value > 0x40000000L) {
            this.unit = GB_UNIT;
            this.valueInUnit = new Float(this.value).floatValue() / 1.0737418E9f;
        } else if (this.value > 0x100000L) {
            this.unit = MB_UNIT;
            this.valueInUnit = new Float(this.value).floatValue() / 1048576.0f;
        } else {
            this.unit = KB_UNIT;
            this.valueInUnit = new Float(this.value).floatValue() / 1024.0f;
        }
    }

    public long getValue() {
        return this.value;
    }

    public float getValueInUnit() {
        return this.valueInUnit;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getPercent() {
        if (this.max > 0L) {
            DecimalFormat formatter = new DecimalFormat("0.0");
            return formatter.format(new Float(this.value).floatValue() / (float)this.max * 100.0f) + "%";
        }
        return "";
    }
}

