/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;

public abstract class AbstractQuotaStatsUpdater
implements QuotaStatsUpdater {
    protected String name;
    protected String label;
    protected String descriptionLabel;
    protected static Log log = LogFactory.getLog(AbstractQuotaStatsUpdater.class);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDescriptionLabel(String descriptionLabel) {
        this.descriptionLabel = descriptionLabel;
    }

    @Override
    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @Override
    public void updateStatistics(CoreSession session, DocumentEventContext docCtx, Event event) throws ClientException {
        block24: {
            DocumentModel doc = docCtx.getSourceDocument();
            if (!this.needToProcessEventOnDocument(event, doc)) {
                log.debug((Object)"Exit Listener !!!!");
                return;
            }
            String eventName = event.getName();
            try {
                if ("documentCreated".equals(eventName)) {
                    this.processDocumentCreated(session, doc, docCtx);
                } else if ("aboutToRemove".equals(eventName) || "aboutToRemoveVersion".equals(eventName)) {
                    this.processDocumentAboutToBeRemoved(session, doc, docCtx);
                } else if ("documentCreatedByCopy".equals(eventName)) {
                    this.processDocumentCopied(session, doc, docCtx);
                } else if ("documentMoved".equals(eventName)) {
                    DocumentRef sourceParentRef = (DocumentRef)docCtx.getProperty("parentPath");
                    DocumentModel sourceParent = session.getDocument(sourceParentRef);
                    this.processDocumentMoved(session, doc, sourceParent, docCtx);
                } else if ("documentModified".equals(eventName)) {
                    this.processDocumentUpdated(session, doc, docCtx);
                } else if ("beforeDocumentModification".equals(eventName)) {
                    this.processDocumentBeforeUpdate(session, doc, docCtx);
                } else if ("lifecycle_transition_event".equals(eventName)) {
                    this.processDocumentTrashOp(session, doc, docCtx);
                } else if ("documentCheckedIn".equals(eventName)) {
                    this.processDocumentCheckedIn(session, doc, docCtx);
                } else if ("documentCheckedOut".equals(eventName)) {
                    this.processDocumentCheckedOut(session, doc, docCtx);
                } else if ("documentRestored".equals(eventName)) {
                    this.processDocumentRestored(session, doc, docCtx);
                } else if ("beforeRestoringDocument".equals(eventName)) {
                    this.processDocumentBeforeRestore(session, doc, docCtx);
                }
            }
            catch (ClientException e) {
                ClientException e2 = this.handleException(e, event);
                if (e2 == null) break block24;
                throw e2;
            }
        }
    }

    protected List<DocumentModel> getAncestors(CoreSession session, DocumentModel doc) throws ClientException {
        ArrayList<DocumentModel> ancestors = new ArrayList<DocumentModel>();
        if (doc != null && doc.getParentRef() != null) {
            doc = session.getDocument(doc.getParentRef());
            while (doc != null && !doc.getPath().isRoot()) {
                ancestors.add(doc);
                doc = session.getDocument(doc.getParentRef());
            }
        }
        return ancestors;
    }

    protected abstract ClientException handleException(ClientException var1, Event var2);

    protected abstract boolean needToProcessEventOnDocument(Event var1, DocumentModel var2);

    protected abstract void processDocumentCreated(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentCopied(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentCheckedIn(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentCheckedOut(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentUpdated(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentMoved(CoreSession var1, DocumentModel var2, DocumentModel var3, DocumentEventContext var4) throws ClientException;

    protected abstract void processDocumentAboutToBeRemoved(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentBeforeUpdate(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentTrashOp(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentRestored(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected abstract void processDocumentBeforeRestore(CoreSession var1, DocumentModel var2, DocumentEventContext var3) throws ClientException;

    protected void setSystemContextData(DocumentModel doc) {
        doc.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
        doc.putContextData("disableDomainListener", (Serializable)Boolean.valueOf(true));
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
    }
}

