/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;

public class QuotaMaxSizeSetterWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public long maxSize;
    public static final String QUOTA_MAX_SIZE_UPDATE_WORK = "quotaMaxSizeSetter";

    public QuotaMaxSizeSetterWork(long maxSize, List<String> docIds, String repositoryName) {
        this.setDocuments(repositoryName, docIds);
        this.maxSize = maxSize;
    }

    public String getTitle() {
        return QUOTA_MAX_SIZE_UPDATE_WORK;
    }

    public String getCategory() {
        return QUOTA_MAX_SIZE_UPDATE_WORK;
    }

    public void notifyProgress(long current) {
        this.setProgress(new Work.Progress(current, (long)this.docIds.size()));
    }

    public void work() throws Exception {
        new UnrestrictedSessionRunner(this.repositoryName){

            public void run() throws ClientException {
                for (String docId : QuotaMaxSizeSetterWork.this.docIds) {
                    DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(docId));
                    QuotaAware qa = (QuotaAware)doc.getAdapter(QuotaAware.class);
                    if (qa == null) {
                        qa = QuotaAwareDocumentFactory.make(doc, true);
                    }
                    qa.setMaxQuota(QuotaMaxSizeSetterWork.this.maxSize, true, true);
                }
            }
        }.runUnrestricted();
    }
}

