/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaInfo;
import org.nuxeo.runtime.api.Framework;

public class QuotaAwareDocument
implements QuotaAware {
    public static final String DOCUMENTS_SIZE_STATISTICS_FACET = "DocumentsSizeStatistics";
    public static final String DOCUMENTS_SIZE_INNER_SIZE_PROPERTY = "dss:innerSize";
    public static final String DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY = "dss:totalSize";
    public static final String DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY = "dss:sizeTrash";
    public static final String DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY = "dss:sizeVersions";
    public static final String DOCUMENTS_SIZE_MAX_SIZE_PROPERTY = "dss:maxSize";
    protected DocumentModel doc;
    protected static final Log log = LogFactory.getLog(QuotaAwareDocument.class);

    public QuotaAwareDocument(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDoc() {
        return this.doc;
    }

    @Override
    public long getInnerSize() {
        try {
            Long inner = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY);
            return inner != null ? inner : 0L;
        }
        catch (ClientException e) {
            return 0L;
        }
    }

    @Override
    public long getTotalSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (ClientException e) {
            return 0L;
        }
    }

    @Override
    public long getTrashSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (ClientException e) {
            return 0L;
        }
    }

    @Override
    public long getVersionsSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (ClientException e) {
            return 0L;
        }
    }

    @Override
    public void setInnerSize(long size, boolean save) throws ClientException {
        this.doc.setPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, (Serializable)Long.valueOf(size));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, (Serializable)Long.valueOf(size));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (inner size) : " + size + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    protected Number addDelta(String property, long delta) {
        Number oldValue = (Number)this.doc.getPropertyValue(property);
        Number newValue = DeltaLong.deltaOrLong((Number)oldValue, (long)delta);
        this.doc.setPropertyValue(property, (Serializable)newValue);
        return newValue;
    }

    @Override
    public void addInnerSize(long additionalSize, boolean save) throws ClientException {
        Number inner = this.addDelta(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, additionalSize);
        Number total = this.addDelta(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (inner size) : " + inner + ", (total size) : " + total + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addTotalSize(long additionalSize, boolean save) throws ClientException {
        Number total = this.addDelta(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (total size) : " + total + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addTrashSize(long additionalSize, boolean save) throws ClientException {
        Number trash = this.addDelta(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (trash size):" + trash + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addVersionsSize(long additionalSize, boolean save) throws ClientException {
        Number versions = this.addDelta(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (versions size): " + versions + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void save() throws ClientException {
        this.doc.getContextData().putScopedValue(ScopeType.REQUEST, "disableQuotaListener", (Serializable)Boolean.valueOf(true));
        this.doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        this.doc.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
        this.doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
        this.doc = this.doc.getCoreSession().saveDocument(this.doc);
    }

    @Override
    public void save(boolean disableNotifications) throws ClientException {
        if (disableNotifications) {
            this.doc.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
            this.doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
        }
        this.save();
    }

    @Override
    public long getMaxQuota() {
        try {
            Long count = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY);
            return count != null ? count : -1L;
        }
        catch (ClientException e) {
            return -1L;
        }
    }

    @Override
    public void setMaxQuota(long maxSize, boolean save, boolean skipValidation) throws ClientException {
        if (!skipValidation && !((QuotaStatsService)Framework.getLocalService(QuotaStatsService.class)).canSetMaxQuota(maxSize, this.doc, this.doc.getCoreSession())) {
            throw new QuotaExceededException(this.doc, "Can not set " + maxSize + ". Quota exceeded because the quota set on one of the children.");
        }
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, (Serializable)Long.valueOf(maxSize));
        if (save) {
            this.save(false);
        }
    }

    @Override
    public void setMaxQuota(long maxSize, boolean save) throws ClientException {
        this.setMaxQuota(maxSize, save, false);
    }

    @Override
    public QuotaInfo getQuotaInfo() {
        return new QuotaInfo(this.getInnerSize(), this.getTotalSize(), this.getTrashSize(), this.getVersionsSize(), this.getMaxQuota());
    }

    @Override
    public void resetInfos(boolean save) throws ClientException {
        this.doc.setPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        if (save) {
            this.save(true);
        }
    }
}

