/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.count;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DocumentsCountUpdater
extends AbstractQuotaStatsUpdater {
    private static final Log log = LogFactory.getLog(DocumentsCountUpdater.class);
    public static final int BATCH_SIZE = 50;

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        if (doc.isVersion()) {
            return;
        }
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel doc, DocumentModel sourceParent, DocumentEventContext docCtx) throws ClientException {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        List<DocumentModel> sourceAncestors = this.getAncestors(session, sourceParent);
        sourceAncestors.add(0, sourceParent);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
        this.updateCountStatistics(session, doc, sourceAncestors, -docCount);
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, -docCount);
    }

    @Override
    protected ClientException handleException(ClientException e, Event event) {
        return e;
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel targetDoc) {
        return true;
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
    }

    protected void updateCountStatistics(CoreSession session, DocumentModel doc, List<DocumentModel> ancestors, long count) throws ClientException {
        if (ancestors == null || ancestors.isEmpty()) {
            return;
        }
        if (count == 0L) {
            return;
        }
        if (!doc.hasFacet("Folderish")) {
            DocumentModel parent = ancestors.get(0);
            this.updateParentChildrenCount(session, parent, count);
        }
        for (DocumentModel ancestor : ancestors) {
            Number previous;
            if (ancestor.hasFacet("DocumentsCountStatistics")) {
                previous = (Number)ancestor.getPropertyValue("dcs:descendantsCount");
            } else {
                ancestor.addFacet("DocumentsCountStatistics");
                previous = null;
            }
            Number descendantsCount = DeltaLong.deltaOrLong((Number)previous, (long)count);
            ancestor.setPropertyValue("dcs:descendantsCount", (Serializable)descendantsCount);
            this.setSystemContextData(ancestor);
            session.saveDocument(ancestor);
        }
        session.save();
    }

    protected void updateParentChildrenCount(CoreSession session, DocumentModel parent, long count) throws ClientException {
        Number previous;
        if (parent.hasFacet("DocumentsCountStatistics")) {
            previous = (Number)parent.getPropertyValue("dcs:childrenCount");
        } else {
            parent.addFacet("DocumentsCountStatistics");
            previous = null;
        }
        Number childrenCount = DeltaLong.deltaOrLong((Number)previous, (long)count);
        parent.setPropertyValue("dcs:childrenCount", (Serializable)childrenCount);
        this.setSystemContextData(parent);
        session.saveDocument(parent);
    }

    protected long getCount(DocumentModel doc) throws ClientException {
        if (doc.hasFacet("Folderish")) {
            if (doc.hasFacet("DocumentsCountStatistics")) {
                Number count = (Number)doc.getPropertyValue("dcs:descendantsCount");
                return count == null ? 0L : count.longValue();
            }
            return 0L;
        }
        return 1L;
    }

    @Override
    public void computeInitialStatistics(CoreSession session, QuotaStatsInitialWork currentWorker) {
        try {
            Map<String, String> folders = this.getFolders(session);
            Map<String, Count> documentsCountByFolder = this.computeDocumentsCountByFolder(session, folders);
            this.saveDocumentsCount(session, documentsCountByFolder);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getFolders(CoreSession session) throws ClientException {
        try (IterableQueryResult res = session.queryAndFetch("SELECT ecm:uuid, ecm:parentId FROM Document WHERE ecm:mixinType = 'Folderish'", "NXQL", new Object[0]);){
            HashMap<String, String> folders = new HashMap<String, String>();
            for (Map r : res) {
                folders.put((String)r.get("ecm:uuid"), (String)r.get("ecm:parentId"));
            }
            HashMap<String, String> hashMap = folders;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Count> computeDocumentsCountByFolder(CoreSession session, Map<String, String> folders) throws ClientException {
        try (IterableQueryResult res = session.queryAndFetch("SELECT ecm:uuid, ecm:parentId FROM Document", "NXQL", new Object[0]);){
            HashMap<String, Count> foldersCount = new HashMap<String, Count>();
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                if (folders.containsKey(uuid)) continue;
                String folderId = (String)r.get("ecm:parentId");
                if (!foldersCount.containsKey(folderId)) {
                    foldersCount.put(folderId, new Count());
                }
                Count count = (Count)foldersCount.get(folderId);
                ++count.childrenCount;
                ++count.descendantsCount;
                this.updateParentsDocumentsCount(folders, foldersCount, folderId);
            }
            HashMap<String, Count> hashMap = foldersCount;
            return hashMap;
        }
    }

    protected void updateParentsDocumentsCount(Map<String, String> folders, Map<String, Count> foldersCount, String folderId) {
        String parent = folders.get(folderId);
        while (parent != null) {
            if (!foldersCount.containsKey(parent)) {
                foldersCount.put(parent, new Count());
            }
            Count c = foldersCount.get(parent);
            ++c.descendantsCount;
            parent = folders.get(parent);
        }
    }

    protected void saveDocumentsCount(CoreSession session, Map<String, Count> foldersCount) throws ClientException {
        long docsCount = 0L;
        for (Map.Entry<String, Count> entry : foldersCount.entrySet()) {
            String folderId = entry.getKey();
            if (folderId == null) continue;
            try {
                DocumentModel folder = session.getDocument((DocumentRef)new IdRef(folderId));
                if (folder.getPath().isRoot()) continue;
                this.saveDocumentsCount(session, folder, entry.getValue());
                if (++docsCount % 50L != 0L) continue;
                session.save();
                if (!TransactionHelper.isTransactionActive()) continue;
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
            catch (ClientException e) {
                log.warn((Object)e);
                log.debug((Object)e, (Throwable)e);
            }
        }
        session.save();
    }

    protected void saveDocumentsCount(CoreSession session, DocumentModel folder, Count count) throws ClientException {
        if (!folder.hasFacet("DocumentsCountStatistics")) {
            folder.addFacet("DocumentsCountStatistics");
        }
        folder.setPropertyValue("dcs:childrenCount", (Serializable)Long.valueOf(count.childrenCount));
        folder.setPropertyValue("dcs:descendantsCount", (Serializable)Long.valueOf(count.descendantsCount));
        this.setSystemContextData(folder);
        session.saveDocument(folder);
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) {
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    private static class Count {
        public long childrenCount = 0L;
        public long descendantsCount = 0L;

        private Count() {
        }
    }
}

