/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.size.BlobSizeInfo;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.QuotaComputerProcessor;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.ecm.quota.size.SizeUpdateEventContext;
import org.nuxeo.runtime.api.Framework;

public class QuotaSyncListenerChecker
extends AbstractQuotaStatsUpdater {
    public static final String DISABLE_QUOTA_CHECK_LISTENER = "disableQuotaListener";
    private static Log log = LogFactory.getLog(QuotaSyncListenerChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeInitialStatistics(CoreSession unrestrictedSession, QuotaStatsInitialWork currentWorker) {
        QuotaComputerProcessor processor = new QuotaComputerProcessor();
        try {
            String query = "SELECT ecm:uuid FROM Document where ecm:isCheckedInVersion=0 and ecm:isProxy=0 order by dc:created desc";
            IterableQueryResult res = unrestrictedSession.queryAndFetch(query, "NXQL", new Object[0]);
            log.debug((Object)"Starting initial Quota computation");
            long total = res.size();
            log.debug((Object)("Start iteration on " + total + " items"));
            try {
                for (Map r : res) {
                    String uuid = (String)r.get("ecm:uuid");
                    try {
                        this.removeFacet(unrestrictedSession, uuid);
                    }
                    catch (ClientException e) {
                        log.debug((Object)("Could not remove facet for uuid : " + uuid + ", error is : " + e.getMessage()));
                    }
                }
            }
            finally {
                res.close();
            }
            this.removeFacet(unrestrictedSession, unrestrictedSession.getRootDocument().getId());
            unrestrictedSession.save();
            try {
                long idx = 0L;
                res = unrestrictedSession.queryAndFetch(query, "NXQL", new Object[0]);
                for (Map r : res) {
                    String uuid = (String)r.get("ecm:uuid");
                    try {
                        this.computeSizeOnDocument(unrestrictedSession, uuid, processor);
                    }
                    catch (ClientException e) {
                        log.warn((Object)("Could not computeSizeOnDocument : " + e.getMessage()));
                    }
                    ++idx;
                    currentWorker.notifyProgress(idx++, total);
                }
            }
            finally {
                res.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during initial Quota Size computation", (Throwable)e);
        }
    }

    private void removeFacet(CoreSession unrestrictedSession, String uuid) throws ClientException {
        DocumentModel target = unrestrictedSession.getDocument((DocumentRef)new IdRef(uuid));
        if (target.hasFacet("DocumentsSizeStatistics")) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " already up to date"));
            }
            QuotaAware quotaDoc = (QuotaAware)target.getAdapter(QuotaAware.class);
            quotaDoc.resetInfos(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)(target.getPathAsString() + " reset to " + quotaDoc.getQuotaInfo()));
            }
            target.removeFacet("DocumentsSizeStatistics");
            target.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
            target.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
            target.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
            target.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            target.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
            target = unrestrictedSession.saveDocument(target);
        }
    }

    protected void computeSizeOnDocument(CoreSession unrestrictedSession, String uuid, QuotaComputerProcessor processor) throws ClientException {
        IdRef ref = new IdRef(uuid);
        DocumentModel target = unrestrictedSession.getDocument((DocumentRef)ref);
        if (log.isTraceEnabled()) {
            log.trace((Object)("process Quota initial computation on uuid " + uuid));
        }
        if (unrestrictedSession.exists((DocumentRef)ref)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " started update"));
            }
            SizeUpdateEventContext quotaCtx = this.updateEventToProcessNewDocument(unrestrictedSession, target);
            quotaCtx.setProperty("sourceEvent", (Serializable)((Object)"documentUpdateInitialStats"));
            quotaCtx.getProperties().put("_UPDATE_TRASH", "deleted".equals(target.getCurrentLifeCycleState()));
            processor.processQuotaComputation(quotaCtx);
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " update completed"));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("doc with uuid " + uuid + " does not exist"));
        }
    }

    @Override
    protected ClientException handleException(ClientException e, Event event) {
        if (e instanceof QuotaExceededException) {
            log.info((Object)("Current event " + event.getName() + " would break Quota restriction, rolling back"));
            event.markRollBack("Quota Exceeded", (Exception)((Object)e));
        }
        return e;
    }

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        if (targetDoc.isVersion()) {
            return;
        }
        BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            log.trace((Object)("  add Quota Facet on " + targetDoc.getPathAsString()));
            QuotaAwareDocumentFactory.make(targetDoc, true);
        }
        if (bsi.getBlobSizeDelta() != 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCreated");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        BlobSizeInfo bsi = this.computeSizeImpact(doc, false);
        if (bsi.getBlobSize() != 0L) {
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCheckedIn");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        BlobSizeInfo bsi = this.computeSizeImpact(doc, false);
        if (bsi.getBlobSize() != 0L) {
            this.checkConstraints(session, doc, doc.getParentRef(), bsi, true);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCheckedOut");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, true);
        log.debug((Object)("calling processDocumentBeforeUpdate, bsi=" + bsi.toString()));
        if (bsi.getBlobSizeDelta() != 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "beforeDocumentModification");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            long total = quotaDoc.getTotalSize() - quotaDoc.getVersionsSize() - quotaDoc.getTrashSize();
            BlobSizeInfo bsi = new BlobSizeInfo();
            bsi.blobSize = total;
            bsi.blobSizeDelta = total;
            if (total > 0L) {
                this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
                SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCreatedByCopy");
                this.sendUpdateEvents(asyncEventCtx);
            }
        }
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel targetDoc, DocumentModel sourceParent, DocumentEventContext docCtx) throws ClientException {
        if (((Serializable)docCtx.getProperties().get("destinationRef")).equals(sourceParent.getRef())) {
            log.debug((Object)(targetDoc.getPathAsString() + "(" + targetDoc.getId() + ") - document is just being renamed, skipping"));
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        long total = 0L;
        if (quotaDoc != null) {
            total = quotaDoc.getTotalSize();
        }
        BlobSizeInfo bsi = new BlobSizeInfo();
        bsi.blobSize = total;
        bsi.blobSizeDelta = total;
        if (total > 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentMoved");
            long versSize = quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            this.sendUpdateEvents(asyncEventCtx);
            BlobSizeInfo bsiRemove = new BlobSizeInfo();
            bsiRemove.blobSize = total;
            bsiRemove.blobSizeDelta = -total;
            asyncEventCtx = new SizeUpdateEventContext(session, docCtx, sourceParent, bsiRemove, "documentMoved");
            versSize = -quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            List<String> sourceParentUUIDs = this.getParentUUIDS(session, sourceParent);
            sourceParentUUIDs.add(0, sourceParent.getId());
            asyncEventCtx.setParentUUIds(sourceParentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        if (targetDoc.isVersion()) {
            ArrayList<String> parentUUIDs = new ArrayList<String>();
            parentUUIDs.add(targetDoc.getSourceId());
            parentUUIDs.addAll(this.getParentUUIDS(session, (DocumentRef)new IdRef(targetDoc.getSourceId())));
            QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
            BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi.getBlobSize(), "aboutToRemoveVersion");
            asyncEventCtx.setParentUUIds(parentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        long total = 0L;
        long versSize = 0L;
        if (quotaDoc == null) {
            BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
            total = bsi.getBlobSize();
            log.debug((Object)("Document " + targetDoc.getId() + " doesn't have the facet quotaDoc. Compute impacted size:" + total));
        }
        if (quotaDoc != null) {
            total = quotaDoc.getTotalSize();
            versSize = -quotaDoc.getVersionsSize();
            log.debug((Object)("Found facet quotaDoc on document  " + targetDoc.getId() + ".Notifying QuotaComputerProcessor with total size: " + total + " and versions size: " + versSize));
        }
        if (total > 0L) {
            List<String> parentUUIDs = this.getParentUUIDS(session, targetDoc);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, total, "aboutToRemove");
            if (versSize != 0L) {
                asyncEventCtx.setVersionsSize(versSize);
            }
            asyncEventCtx.setParentUUIds(parentUUIDs);
            asyncEventCtx.getProperties().put("_UPDATE_TRASH", "deleted".equals(targetDoc.getCurrentLifeCycleState()));
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel targetDoc) {
        if (targetDoc == null) {
            return false;
        }
        if (targetDoc.isProxy()) {
            log.debug((Object)"Escape from listener: not precessing proxies");
            return false;
        }
        Boolean block = (Boolean)targetDoc.getContextData().getScopedValue(ScopeType.REQUEST, DISABLE_QUOTA_CHECK_LISTENER);
        if (block != null && block.booleanValue()) {
            log.debug((Object)"Escape from listener to avoid reentrancy");
            return false;
        }
        return true;
    }

    protected void sendUpdateEvents(SizeUpdateEventContext eventCtx) throws ClientException {
        Event quotaUpdateEvent = eventCtx.newQuotaUpdateEvent();
        log.debug((Object)("prepared event on target tree with context " + eventCtx.toString()));
        EventService es = (EventService)Framework.getLocalService(EventService.class);
        es.fireEvent(quotaUpdateEvent);
    }

    protected List<String> getParentUUIDS(CoreSession unrestrictedSession, DocumentRef docRef) throws ClientException {
        DocumentRef[] parentRefs;
        ArrayList<String> result = new ArrayList<String>();
        if (docRef == null || docRef.toString() == null) {
            return result;
        }
        for (DocumentRef parentRef : parentRefs = unrestrictedSession.getParentDocumentRefs(docRef)) {
            result.add(parentRef.toString());
        }
        return result;
    }

    protected List<String> getParentUUIDS(CoreSession unrestrictedSession, DocumentModel doc) throws ClientException {
        return this.getParentUUIDS(unrestrictedSession, doc.getRef());
    }

    protected void checkConstraints(CoreSession unrestrictedSession, DocumentModel doc, DocumentRef parentRef, BlobSizeInfo bsi) throws ClientException {
        this.checkConstraints(unrestrictedSession, doc, parentRef, bsi, false);
    }

    protected void checkConstraints(CoreSession unrestrictedSession, DocumentModel doc, DocumentRef parentRef, BlobSizeInfo bsi, boolean checkWithTotalSize) throws ClientException {
        if (parentRef == null) {
            return;
        }
        long addition = bsi.blobSizeDelta;
        if (checkWithTotalSize) {
            addition = bsi.getBlobSize();
        }
        if (addition <= 0L) {
            return;
        }
        List parents = unrestrictedSession.getParentDocuments(parentRef);
        parents.add(unrestrictedSession.getDocument(parentRef));
        for (DocumentModel parent : parents) {
            QuotaAware qap = (QuotaAware)parent.getAdapter(QuotaAware.class);
            if (qap == null || "UserWorkspacesRoot".equals(parent.getType()) || qap.getMaxQuota() <= 0L || qap.getTotalSize() + addition <= qap.getMaxQuota()) continue;
            log.info((Object)("Raising Quota Exception on " + doc.getPathAsString()));
            throw new QuotaExceededException(parent, doc, qap.getMaxQuota());
        }
    }

    protected BlobSizeInfo computeSizeImpact(DocumentModel doc, boolean onlyIfBlobHasChanged) throws ClientException {
        BlobSizeInfo result = new BlobSizeInfo();
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        result.blobSize = quotaDoc != null ? quotaDoc.getInnerSize() : 0L;
        List<Blob> blobs = this.getBlobs(doc, onlyIfBlobHasChanged);
        if (blobs.size() == 0) {
            if (onlyIfBlobHasChanged) {
                result.blobSizeDelta = 0L;
            } else {
                result.blobSizeDelta = -result.blobSize;
                result.blobSize = 0L;
            }
        } else {
            long size = 0L;
            for (Blob blob : blobs) {
                if (blob == null) continue;
                size += blob.getLength();
            }
            result.blobSizeDelta = size - result.blobSize;
            result.blobSize = size;
        }
        return result;
    }

    protected List<Blob> getBlobs(DocumentModel doc, boolean onlyIfBlobHasChanged) throws ClientException {
        try {
            boolean needRecompute;
            QuotaSizeService sizeService = (QuotaSizeService)Framework.getLocalService(QuotaSizeService.class);
            HashSet<String> excludedPathSet = new HashSet<String>(sizeService.getExcludedPathList());
            BlobsExtractor extractor = new BlobsExtractor();
            extractor.setExtractorProperties(null, new HashSet<String>(excludedPathSet), true);
            List blobProperties = extractor.getBlobsProperties(doc);
            boolean bl = needRecompute = !onlyIfBlobHasChanged;
            if (onlyIfBlobHasChanged) {
                for (Property blobProperty : blobProperties) {
                    if (!blobProperty.isDirty()) continue;
                    needRecompute = true;
                    break;
                }
            }
            ArrayList<Blob> result = new ArrayList<Blob>();
            if (needRecompute) {
                for (Property blobProperty : blobProperties) {
                    Blob blob = (Blob)blobProperty.getValue();
                    String schema = blobProperty.getParent().getSchema().getName();
                    String propName = blobProperty.getName();
                    log.debug((Object)String.format("Using [%s:%s] for quota blob computation (size : %d)", schema, propName, blob.getLength()));
                    result.add(blob);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ClientException("Unable to extract Blob size", (Throwable)e);
        }
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) throws ClientException {
        String transition = (String)docCtx.getProperties().get("transition");
        if (transition != null && !"delete".equals(transition) && !"undelete".equals(transition)) {
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            long absSize = quotaDoc.getTotalSize();
            if (quotaDoc.getDoc().isFolder()) {
                absSize = quotaDoc.getInnerSize();
                log.debug((Object)(quotaDoc.getDoc().getPathAsString() + " is a folder, just inner size (" + absSize + ") taken into account for trash size"));
            }
            long total = "delete".equals(transition) ? absSize : -absSize;
            BlobSizeInfo bsi = new BlobSizeInfo();
            bsi.blobSize = total;
            bsi.blobSizeDelta = total;
            if (absSize > 0L) {
                SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, transition);
                this.sendUpdateEvents(asyncEventCtx);
            }
        }
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        long total;
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc != null && (total = quotaDoc.getTotalSize()) > 0L) {
            List<String> parentUUIDs = this.getParentUUIDS(session, targetDoc);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, total, "aboutToRemove");
            long versSize = -quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            asyncEventCtx.setParentUUIds(parentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) throws ClientException {
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            log.debug((Object)("  add Quota Facet on " + targetDoc.getPathAsString()));
            quotaDoc = QuotaAwareDocumentFactory.make(targetDoc, true);
        }
        quotaDoc.resetInfos(true);
        this.sendUpdateEvents(this.updateEventToProcessNewDocument(session, targetDoc));
    }

    private SizeUpdateEventContext updateEventToProcessNewDocument(CoreSession unrestrictedSession, DocumentModel target) throws ClientException {
        BlobSizeInfo bsi = this.computeSizeImpact(target, false);
        SizeUpdateEventContext quotaCtx = null;
        List versions = unrestrictedSession.getVersions(target.getRef());
        if (versions.isEmpty() && !"deleted".equals(target.getCurrentLifeCycleState())) {
            quotaCtx = new SizeUpdateEventContext(unrestrictedSession, bsi, "documentCreated", target);
        } else {
            long versionsSize = 0L;
            for (DocumentModel documentModel : versions) {
                versionsSize += this.computeSizeImpact((DocumentModel)documentModel, (boolean)false).blobSize;
            }
            quotaCtx = new SizeUpdateEventContext(unrestrictedSession, bsi, "documentUpdateInitialStats", target);
            quotaCtx.setVersionsSize(versionsSize);
        }
        return quotaCtx;
    }
}

