/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocument;

public class QuotaAwareDocumentFactory
implements DocumentAdapterFactory {
    public static QuotaAwareDocument make(DocumentModel doc, boolean save) {
        if (!doc.hasFacet("DocumentsSizeStatistics")) {
            doc.addFacet("DocumentsSizeStatistics");
            if (save) {
                DocumentModel origDoc = doc;
                QuotaUtils.disableListeners(doc);
                doc = doc.getCoreSession().saveDocument(doc);
                QuotaUtils.clearContextData(doc);
                QuotaUtils.clearContextData(origDoc);
            }
        }
        return (QuotaAwareDocument)doc.getAdapter(QuotaAware.class);
    }

    public Object getAdapter(DocumentModel doc, Class<?> adapter) {
        if (doc.hasFacet("DocumentsSizeStatistics")) {
            return adapter.cast(new QuotaAwareDocument(doc));
        }
        return null;
    }
}

