/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaInfo;
import org.nuxeo.runtime.api.Framework;

public class QuotaAwareDocument
implements QuotaAware {
    public static final String DOCUMENTS_SIZE_STATISTICS_FACET = "DocumentsSizeStatistics";
    public static final String DOCUMENTS_SIZE_INNER_SIZE_PROPERTY = "dss:innerSize";
    public static final String DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY = "dss:totalSize";
    public static final String DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY = "dss:sizeTrash";
    public static final String DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY = "dss:sizeVersions";
    public static final String DOCUMENTS_SIZE_MAX_SIZE_PROPERTY = "dss:maxSize";
    protected DocumentModel doc;
    protected static final Log log = LogFactory.getLog(QuotaAwareDocument.class);

    public QuotaAwareDocument(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDoc() {
        return this.doc;
    }

    @Override
    public long getInnerSize() {
        try {
            Long inner = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY);
            return inner != null ? inner : 0L;
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getTotalSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getTrashSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getVersionsSize() {
        try {
            Long total = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY);
            return total != null ? total : 0L;
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public void setInnerSize(long size, boolean save) {
        this.doc.setPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, (Serializable)Long.valueOf(size));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, (Serializable)Long.valueOf(size));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (inner size) : " + size + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    protected Number addDelta(String property, long delta) {
        Number oldValue = (Number)this.doc.getPropertyValue(property);
        Number newValue = DeltaLong.deltaOrLong((Number)oldValue, (long)delta);
        if (newValue.longValue() < 0L) {
            newValue = 0L;
        }
        this.doc.setPropertyValue(property, (Serializable)Long.valueOf(newValue.longValue()));
        return newValue;
    }

    @Override
    public void addInnerSize(long additionalSize, boolean save) {
        Number inner = this.addDelta(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, additionalSize);
        Number total = this.addDelta(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (inner size) : " + inner + ", (total size) : " + total + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addTotalSize(long additionalSize, boolean save) {
        Number total = this.addDelta(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (total size) : " + total + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addTrashSize(long additionalSize, boolean save) {
        Number trash = this.addDelta(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (trash size):" + trash + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void addVersionsSize(long additionalSize, boolean save) {
        Number versions = this.addDelta(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, additionalSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (versions size): " + versions + " on document " + this.doc.getId()));
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void save() {
        this.doc.putContextData("disableQuotaListener", (Serializable)Boolean.TRUE);
        QuotaUtils.disableListeners(this.doc);
        DocumentModel origDoc = this.doc;
        this.doc = this.doc.getCoreSession().saveDocument(this.doc);
        QuotaUtils.clearContextData(this.doc);
        QuotaUtils.clearContextData(origDoc);
    }

    @Override
    public void save(boolean disableNotifications) {
        this.save();
    }

    @Override
    public long getMaxQuota() {
        try {
            Long count = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY);
            return count != null ? count : -1L;
        }
        catch (PropertyException e) {
            return -1L;
        }
    }

    @Override
    public void setMaxQuota(long maxSize, boolean save, boolean skipValidation) {
        if (!skipValidation && !((QuotaStatsService)Framework.getLocalService(QuotaStatsService.class)).canSetMaxQuota(maxSize, this.doc, this.doc.getCoreSession())) {
            throw new QuotaExceededException(this.doc, "Can not set " + maxSize + ". Quota exceeded because the quota set on one of the children.");
        }
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, (Serializable)Long.valueOf(maxSize));
        if (save) {
            this.save(false);
        }
    }

    @Override
    public void setMaxQuota(long maxSize, boolean save) {
        this.setMaxQuota(maxSize, save, false);
    }

    @Override
    public QuotaInfo getQuotaInfo() {
        return new QuotaInfo(this.getInnerSize(), this.getTotalSize(), this.getTrashSize(), this.getVersionsSize(), this.getMaxQuota());
    }

    @Override
    public void resetInfos(boolean save) {
        this.doc.setPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        try {
            this.invalidateTotalSizeCache();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to invalidate cache");
        }
        if (save) {
            this.save(true);
        }
    }

    @Override
    public void invalidateTotalSizeCache() throws IOException {
        this.invalidateCache("quota-totalsize-cache");
    }

    protected Cache getCache(String cacheName) {
        CacheService cs = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cs.getCache(cacheName);
        if (cache != null) {
            log.trace((Object)("Using cache " + cacheName));
            return cache;
        }
        throw new RuntimeException("Unable to retrieve cache " + cacheName);
    }

    protected void invalidateCache(String cacheName) throws IOException {
        try {
            Cache cache = this.getCache(cacheName);
            cache.invalidate(this.getCacheEntry(this.doc.getId()));
        }
        catch (RuntimeException e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Override
    public Long getTotalSizeCache() throws IOException {
        return this.getSizeInCache("quota-totalsize-cache");
    }

    protected Long getSizeInCache(String cacheName) throws IOException {
        try {
            Cache cache = this.getCache(cacheName);
            return (Long)cache.get(this.getCacheEntry(this.doc.getId()));
        }
        catch (RuntimeException e) {
            log.warn((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void putTotalSizeCache(long size) throws IOException {
        this.putSizeInCache("quota-totalsize-cache", size);
    }

    protected void putSizeInCache(String cacheName, long size) throws IOException {
        try {
            Cache cache = this.getCache(cacheName);
            cache.put(this.getCacheEntry(this.doc.getId()), (Serializable)Long.valueOf(size));
        }
        catch (RuntimeException e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Override
    public boolean totalSizeCacheExists() {
        try {
            return this.getCache("quota-totalsize-cache") != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    protected String getCacheEntry(String ... params) {
        return StringUtils.join((Object[])params, (char)'-');
    }
}

