/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.RecoverableClientException;

public class QuotaExceededException
extends RecoverableClientException {
    private static final long serialVersionUID = 1L;
    protected long quotaValue;
    protected String targetPath;
    protected String addedDocumentID;

    public QuotaExceededException(DocumentModel targetDocument, String message) {
        super(message, "label.quotaException." + message, new String[]{targetDocument.getPathAsString()});
        this.targetPath = targetDocument.getPathAsString();
    }

    public QuotaExceededException(DocumentModel targetDocument, DocumentModel addedDocument, long quotaValue) {
        this(targetDocument.getPathAsString(), addedDocument.getId(), quotaValue);
    }

    public QuotaExceededException(String targetDocumentPath, String addedDocumentID, long quotaValue) {
        super("QuotaExceeded", "label.quotaException.QuotaExceeded", new String[]{targetDocumentPath, addedDocumentID});
        this.quotaValue = quotaValue;
        this.addedDocumentID = addedDocumentID;
        this.targetPath = targetDocumentPath;
    }

    public long getQuotaValue() {
        return this.quotaValue;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getAddedDocumentID() {
        return this.addedDocumentID;
    }

    public static QuotaExceededException unwrap(Throwable e) {
        if (e instanceof QuotaExceededException) {
            return (QuotaExceededException)((Object)e);
        }
        if (e.getCause() != null) {
            return QuotaExceededException.unwrap(e.getCause());
        }
        return null;
    }

    public static boolean isQuotaExceededException(Throwable e) {
        return QuotaExceededException.unwrap(e) != null;
    }
}

