/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.SizeUpdateEventContext;

public class QuotaComputerProcessor
implements PostCommitEventListener {
    protected static final Log log = LogFactory.getLog(QuotaComputerProcessor.class);

    public void handleEvent(EventBundle eventBundle) {
        if (eventBundle.containsEventName("quotaUpdateNeeded")) {
            for (Event event : eventBundle) {
                SizeUpdateEventContext quotaCtx;
                EventContext ctx;
                if (!event.getName().equals("quotaUpdateNeeded") || !((ctx = event.getContext()) instanceof DocumentEventContext) || (quotaCtx = SizeUpdateEventContext.unwrap((DocumentEventContext)ctx)) == null) continue;
                this.processQuotaComputation(quotaCtx);
                this.debugCheck(quotaCtx);
            }
        }
    }

    protected void debugCheck(SizeUpdateEventContext quotaCtx) {
        DocumentModel sourceDocument;
        String sourceEvent = quotaCtx.getSourceEvent();
        CoreSession session = quotaCtx.getCoreSession();
        if (session.exists((sourceDocument = quotaCtx.getSourceDocument()).getRef())) {
            DocumentModel doc = session.getDocument(sourceDocument.getRef());
            if (log.isTraceEnabled()) {
                if (doc.hasFacet("DocumentsSizeStatistics")) {
                    log.trace((Object)"Double Check Facet was added OK");
                } else {
                    log.trace((Object)"No facet !!!!");
                }
            }
        } else {
            log.debug((Object)("Document " + sourceDocument.getRef() + " no longer exists (" + sourceEvent + ")"));
        }
    }

    public void processQuotaComputation(SizeUpdateEventContext quotaCtx) {
        QuotaAware quotaDoc;
        String sourceEvent = quotaCtx.getSourceEvent();
        CoreSession session = quotaCtx.getCoreSession();
        DocumentModel sourceDocument = quotaCtx.getSourceDocument();
        if (sourceDocument instanceof ShallowDocumentModel && !"aboutToRemove".equals(sourceEvent) && !"aboutToRemoveVersion".equals(sourceEvent)) {
            log.error((Object)("Unable to reconnect Document " + sourceDocument.getPathAsString() + " on event " + sourceEvent));
            return;
        }
        ArrayList<DocumentModel> parents = new ArrayList<DocumentModel>();
        log.debug((Object)(sourceEvent + "/ compute Quota on " + sourceDocument.getPathAsString() + " and parents"));
        if ("aboutToRemove".equals(sourceEvent) || "aboutToRemoveVersion".equals(sourceEvent)) {
            for (String id : quotaCtx.getParentUUIds()) {
                if (!session.exists((DocumentRef)new IdRef(id))) continue;
                parents.add(session.getDocument((DocumentRef)new IdRef(id)));
            }
        } else if ("documentMoved".equals(sourceEvent)) {
            if (quotaCtx.getParentUUIds() != null && quotaCtx.getParentUUIds().size() > 0) {
                for (String id : quotaCtx.getParentUUIds()) {
                    if (!session.exists((DocumentRef)new IdRef(id))) continue;
                    parents.add(session.getDocument((DocumentRef)new IdRef(id)));
                }
            } else {
                parents.addAll(this.getParents(sourceDocument, session));
            }
        } else {
            if ((sourceDocument = session.getDocument(sourceDocument.getRef())).getRef() == null) {
                log.error((Object)"SourceDocument has no ref");
            } else {
                parents.addAll(this.getParents(sourceDocument, session));
            }
            quotaDoc = (QuotaAware)sourceDocument.getAdapter(QuotaAware.class);
            if (!"documentCreatedByCopy".equals(sourceEvent)) {
                if (quotaDoc == null) {
                    log.debug((Object)("  add Quota Facet on " + sourceDocument.getPathAsString()));
                    quotaDoc = QuotaAwareDocumentFactory.make(sourceDocument, false);
                } else {
                    log.debug((Object)("  update Quota Facet on " + sourceDocument.getPathAsString()));
                }
                if ("documentCheckedIn".equals(sourceEvent)) {
                    long versionSize = this.getVersionSizeFromCtx(quotaCtx);
                    quotaDoc.addVersionsSize(versionSize, false);
                    quotaDoc.addTotalSize(versionSize, true);
                } else if (!"documentCheckedOut".equals(sourceEvent)) {
                    if ("delete".equals(sourceEvent) || "undelete".equals(sourceEvent)) {
                        quotaDoc.addTrashSize(quotaCtx.getBlobSize(), true);
                    } else if ("documentUpdateInitialStats".equals(sourceEvent)) {
                        quotaDoc.addInnerSize(quotaCtx.getBlobSize(), false);
                        quotaDoc.addTotalSize(quotaCtx.getVersionsSize(), false);
                        quotaDoc.addTrashSize(quotaCtx.getTrashSize(), false);
                        quotaDoc.addVersionsSize(quotaCtx.getVersionsSize(), true);
                    } else {
                        quotaDoc.addInnerSize(quotaCtx.getBlobDelta(), true);
                    }
                }
            } else if (!sourceDocument.isFolder()) {
                quotaDoc.resetInfos(false);
                quotaDoc.setInnerSize(quotaCtx.getBlobSize(), true);
            }
        }
        if (parents.size() > 0) {
            if ("documentCheckedIn".equals(sourceEvent)) {
                long versionSize = this.getVersionSizeFromCtx(quotaCtx);
                this.processOnParents(parents, versionSize, 0L, versionSize, true, false, true);
            } else if (!"documentCheckedOut".equals(sourceEvent)) {
                if ("delete".equals(sourceEvent) || "undelete".equals(sourceEvent)) {
                    this.processOnParents(parents, 0L, quotaCtx.getBlobSize(), false, true);
                } else if ("aboutToRemoveVersion".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), 0L, quotaCtx.getBlobDelta(), true, false, true);
                } else if ("aboutToRemove".equals(sourceEvent)) {
                    log.debug((Object)("Processing document about to be removed on parents. Total: " + quotaCtx.getBlobDelta() + " , trash size: " + quotaCtx.getTrashSize() + " , versions size: " + quotaCtx.getVersionsSize()));
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), quotaCtx.getBlobDelta() - quotaCtx.getVersionsSize(), quotaCtx.getVersionsSize(), true, quotaCtx.getProperties().get("_UPDATE_TRASH") != null && (Boolean)quotaCtx.getProperties().get("_UPDATE_TRASH") != false, true);
                } else if ("documentMoved".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobDelta(), 0L, quotaCtx.getVersionsSize(), true, false, true);
                } else if ("documentUpdateInitialStats".equals(sourceEvent)) {
                    quotaDoc = (QuotaAware)sourceDocument.getAdapter(QuotaAware.class);
                    if (quotaDoc.getInnerSize() > 0L) {
                        this.processOnParents(parents, quotaCtx.getBlobSize() + quotaCtx.getVersionsSize(), quotaCtx.getBlobSize(), quotaCtx.getVersionsSize(), true, quotaCtx.getProperties().get("_UPDATE_TRASH") != null && (Boolean)quotaCtx.getProperties().get("_UPDATE_TRASH") != false, true);
                    } else {
                        log.debug((Object)"No inner size, parents not updated");
                    }
                } else if ("documentCreatedByCopy".equals(sourceEvent)) {
                    this.processOnParents(parents, quotaCtx.getBlobSize());
                } else {
                    this.processOnParents(parents, quotaCtx.getBlobDelta());
                }
            }
        }
    }

    private long getVersionSizeFromCtx(SizeUpdateEventContext quotaCtx) {
        return quotaCtx.getBlobSize();
    }

    protected void processOnParents(List<DocumentModel> parents, long delta) {
        this.processOnParents(parents, delta, 0L, 0L, true, false, false);
    }

    protected void processOnParents(List<DocumentModel> parents, long delta, long trash, boolean total, boolean trashOp) {
        this.processOnParents(parents, delta, trash, 0L, total, trashOp, false);
    }

    protected void processOnParents(List<DocumentModel> parents, long deltaTotal, long trashSize, long deltaVersions, boolean total, boolean trashOp, boolean versionsOp) {
        for (DocumentModel parent : parents) {
            QuotaAware quotaDoc = (QuotaAware)parent.getAdapter(QuotaAware.class);
            boolean toSave = false;
            if (quotaDoc == null) {
                log.debug((Object)("   add Quota Facet on parent " + parent.getPathAsString()));
                quotaDoc = QuotaAwareDocumentFactory.make(parent, false);
                toSave = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("   update Quota Facet on parent " + parent.getPathAsString() + " (" + quotaDoc.getQuotaInfo() + ")"));
            }
            if (total) {
                quotaDoc.addTotalSize(deltaTotal, false);
                toSave = true;
            }
            if (trashOp) {
                quotaDoc.addTrashSize(trashSize, false);
                toSave = true;
            }
            if (versionsOp) {
                quotaDoc.addVersionsSize(deltaVersions, false);
                toSave = true;
            }
            if (toSave) {
                quotaDoc.save(true);
            }
            try {
                quotaDoc.invalidateTotalSizeCache();
            }
            catch (IOException e) {
                log.error((Object)(e.getMessage() + ": unable to invalidate cache " + "quota-totalsize-cache" + " for " + quotaDoc.getDoc().getId()));
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("   ==> " + parent.getPathAsString() + " (" + quotaDoc.getQuotaInfo() + ")"));
        }
    }

    protected List<DocumentModel> getParents(DocumentModel sourceDocument, CoreSession session) {
        DocumentRef[] parentRefs;
        ArrayList<DocumentModel> parents = new ArrayList<DocumentModel>();
        for (DocumentRef documentRef : parentRefs = session.getParentDocumentRefs(sourceDocument.getRef())) {
            parents.add(session.getDocument(documentRef));
        }
        return parents;
    }
}

