/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaInfo;
import org.nuxeo.runtime.api.Framework;

public class QuotaAwareDocument
implements QuotaAware {
    public static final String DOCUMENTS_SIZE_STATISTICS_FACET = "DocumentsSizeStatistics";
    public static final String DOCUMENTS_SIZE_INNER_SIZE_PROPERTY = "dss:innerSize";
    public static final String DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY = "dss:totalSize";
    public static final String DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY = "dss:sizeTrash";
    public static final String DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY = "dss:sizeVersions";
    public static final String DOCUMENTS_SIZE_MAX_SIZE_PROPERTY = "dss:maxSize";
    protected DocumentModel doc;
    protected static final Log log = LogFactory.getLog(QuotaAwareDocument.class);

    public QuotaAwareDocument(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDoc() {
        return this.doc;
    }

    @Override
    public long getInnerSize() {
        try {
            Number size = (Number)this.doc.getPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY);
            return size == null ? 0L : size.longValue();
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getTotalSize() {
        try {
            Number size = (Number)this.doc.getPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY);
            return size == null ? 0L : size.longValue();
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getTrashSize() {
        try {
            Number size = (Number)this.doc.getPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY);
            return size == null ? 0L : size.longValue();
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    @Override
    public long getVersionsSize() {
        try {
            Number size = (Number)this.doc.getPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY);
            return size == null ? 0L : size.longValue();
        }
        catch (PropertyException e) {
            return 0L;
        }
    }

    protected Number addDelta(String property, long delta) {
        Number oldValue = (Number)this.doc.getPropertyValue(property);
        DeltaLong newValue = DeltaLong.valueOf((Number)oldValue, (long)delta);
        this.doc.setPropertyValue(property, (Serializable)newValue);
        return newValue;
    }

    @Override
    public void addInnerSize(long delta) {
        Number inner = this.addDelta(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, delta);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (inner size) : " + inner + " on document " + this.doc.getId()));
        }
    }

    @Override
    public void addTotalSize(long delta) {
        Number total = this.addDelta(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, delta);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (total size) : " + total + " on document " + this.doc.getId()));
        }
    }

    @Override
    public void addTrashSize(long delta) {
        Number trash = this.addDelta(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, delta);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (trash size):" + trash + " on document " + this.doc.getId()));
        }
    }

    @Override
    public void addVersionsSize(long delta) {
        Number versions = this.addDelta(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, delta);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting quota (versions size): " + versions + " on document " + this.doc.getId()));
        }
    }

    @Override
    public void save() {
        this.doc.putContextData("disableQuotaListener", (Serializable)Boolean.TRUE);
        QuotaUtils.disableListeners(this.doc);
        DocumentModel origDoc = this.doc;
        this.doc = this.doc.getCoreSession().saveDocument(this.doc);
        QuotaUtils.clearContextData(this.doc);
        QuotaUtils.clearContextData(origDoc);
    }

    @Override
    public long getMaxQuota() {
        try {
            Long size = (Long)this.doc.getPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY);
            return size == null ? -1L : size;
        }
        catch (PropertyException e) {
            return -1L;
        }
    }

    @Override
    public void setMaxQuota(long maxSize) {
        this.setMaxQuota(maxSize, false);
    }

    @Override
    public void setMaxQuota(long maxSize, boolean skipValidation) {
        QuotaStatsService quotaStatsService;
        if (!skipValidation && !(quotaStatsService = (QuotaStatsService)Framework.getService(QuotaStatsService.class)).canSetMaxQuota(maxSize, this.doc, this.doc.getCoreSession())) {
            throw new QuotaExceededException(this.doc, "Can not set " + maxSize + ". Quota exceeded because the quota set on one of the children.");
        }
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, (Serializable)Long.valueOf(maxSize));
    }

    @Override
    public QuotaInfo getQuotaInfo() {
        return new QuotaInfo(this.getInnerSize(), this.getTotalSize(), this.getTrashSize(), this.getVersionsSize(), this.getMaxQuota());
    }

    @Override
    public void resetInfos() {
        this.doc.setPropertyValue(DOCUMENTS_SIZE_INNER_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TOTAL_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_TRASH_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_VERSIONS_SIZE_PROPERTY, (Serializable)Long.valueOf(0L));
        this.doc.setPropertyValue(DOCUMENTS_SIZE_MAX_SIZE_PROPERTY, null);
    }
}

