/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;

public class QuotaUtils {
    protected static final List<String> FLAGS = Arrays.asList("disableQuotaListener", "disableAuditLogger", "disableDublinCoreListener", "disableNotificationService", "DisableAutoCheckOut", "disableDomainListener", "disableHtmlSanitizerListener");

    private QuotaUtils() {
    }

    public static void disableListeners(DocumentModel doc) {
        for (String flag : FLAGS) {
            doc.putContextData(flag, (Serializable)Boolean.TRUE);
        }
        doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
    }

    public static void clearContextData(DocumentModel doc) {
        for (String flag : FLAGS) {
            doc.putContextData(flag, null);
        }
        doc.putContextData("VersioningOption", null);
    }
}

