/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.count;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DocumentsCountUpdater
extends AbstractQuotaStatsUpdater {
    private static final Log log = LogFactory.getLog(DocumentsCountUpdater.class);
    public static final int BATCH_SIZE = 50;

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel doc) {
        if (doc.isVersion()) {
            return;
        }
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel doc) {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel doc, DocumentModel sourceParent) {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        List<DocumentModel> sourceAncestors = this.getAncestors(session, sourceParent);
        sourceAncestors.add(0, sourceParent);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, docCount);
        this.updateCountStatistics(session, doc, sourceAncestors, -docCount);
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel doc) {
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        long docCount = this.getCount(doc);
        this.updateCountStatistics(session, doc, ancestors, -docCount);
    }

    @Override
    protected void handleQuotaExceeded(QuotaExceededException e, Event event) {
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel doc) {
        return true;
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel doc) {
    }

    protected void updateCountStatistics(CoreSession session, DocumentModel doc, List<DocumentModel> ancestors, long count) {
        if (ancestors == null || ancestors.isEmpty()) {
            return;
        }
        if (count == 0L) {
            return;
        }
        if (!doc.hasFacet("Folderish")) {
            DocumentModel parent = ancestors.get(0);
            this.updateCount(session, parent, "dcs:childrenCount", count);
        }
        ancestors.forEach(ancestor -> this.updateCount(session, (DocumentModel)ancestor, "dcs:descendantsCount", count));
        session.save();
    }

    protected void updateCount(CoreSession session, DocumentModel parent, String xpath, long count) {
        Number previous;
        if (parent.hasFacet("DocumentsCountStatistics")) {
            previous = (Number)parent.getPropertyValue(xpath);
        } else {
            parent.addFacet("DocumentsCountStatistics");
            previous = null;
        }
        DeltaLong childrenCount = DeltaLong.valueOf((Number)previous, (long)count);
        parent.setPropertyValue(xpath, (Serializable)childrenCount);
        QuotaUtils.disableListeners(parent);
        DocumentModel origParent = parent;
        parent = session.saveDocument(parent);
        QuotaUtils.clearContextData(origParent);
    }

    protected long getCount(DocumentModel doc) {
        if (doc.hasFacet("Folderish")) {
            if (doc.hasFacet("DocumentsCountStatistics")) {
                Number count = (Number)doc.getPropertyValue("dcs:descendantsCount");
                return count == null ? 0L : count.longValue();
            }
            return 0L;
        }
        return 1L;
    }

    @Override
    public void computeInitialStatistics(CoreSession session, QuotaStatsInitialWork currentWorker, String path) {
        Map<String, String> folders = this.getFolders(session);
        Map<String, Count> documentsCountByFolder = this.computeDocumentsCountByFolder(session, folders);
        this.saveDocumentsCount(session, documentsCountByFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getFolders(CoreSession session) {
        try (IterableQueryResult res = session.queryAndFetch("SELECT ecm:uuid, ecm:parentId FROM Document WHERE ecm:mixinType = 'Folderish'", "NXQL", new Object[0]);){
            HashMap<String, String> folders = new HashMap<String, String>();
            for (Map r : res) {
                folders.put((String)r.get("ecm:uuid"), (String)r.get("ecm:parentId"));
            }
            HashMap<String, String> hashMap = folders;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Count> computeDocumentsCountByFolder(CoreSession session, Map<String, String> folders) {
        try (IterableQueryResult res = session.queryAndFetch("SELECT ecm:uuid, ecm:parentId FROM Document", "NXQL", new Object[0]);){
            HashMap<String, Count> foldersCount = new HashMap<String, Count>();
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                if (folders.containsKey(uuid)) continue;
                String folderId = (String)r.get("ecm:parentId");
                if (!foldersCount.containsKey(folderId)) {
                    foldersCount.put(folderId, new Count());
                }
                Count count = (Count)foldersCount.get(folderId);
                ++count.childrenCount;
                ++count.descendantsCount;
                this.updateParentsDocumentsCount(folders, foldersCount, folderId);
            }
            HashMap<String, Count> hashMap = foldersCount;
            return hashMap;
        }
    }

    protected void updateParentsDocumentsCount(Map<String, String> folders, Map<String, Count> foldersCount, String folderId) {
        String parent = folders.get(folderId);
        while (parent != null) {
            if (!foldersCount.containsKey(parent)) {
                foldersCount.put(parent, new Count());
            }
            Count c = foldersCount.get(parent);
            ++c.descendantsCount;
            parent = folders.get(parent);
        }
    }

    protected void saveDocumentsCount(CoreSession session, Map<String, Count> foldersCount) {
        long docsCount = 0L;
        for (Map.Entry<String, Count> entry : foldersCount.entrySet()) {
            DocumentModel folder;
            String folderId = entry.getKey();
            if (folderId == null) continue;
            try {
                folder = session.getDocument((DocumentRef)new IdRef(folderId));
            }
            catch (DocumentNotFoundException e) {
                log.warn((Object)e);
                log.debug((Object)e, (Throwable)e);
                continue;
            }
            if (folder.getPath().isRoot()) continue;
            this.saveDocumentsCount(session, folder, entry.getValue());
            if (++docsCount % 50L != 0L) continue;
            session.save();
            if (!TransactionHelper.isTransactionActive()) continue;
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        session.save();
    }

    protected void saveDocumentsCount(CoreSession session, DocumentModel folder, Count count) {
        if (!folder.hasFacet("DocumentsCountStatistics")) {
            folder.addFacet("DocumentsCountStatistics");
        }
        folder.setPropertyValue("dcs:childrenCount", (Serializable)Long.valueOf(count.childrenCount));
        folder.setPropertyValue("dcs:descendantsCount", (Serializable)Long.valueOf(count.descendantsCount));
        QuotaUtils.disableListeners(folder);
        DocumentModel origFolder = folder;
        session.saveDocument(folder);
        QuotaUtils.clearContextData(origFolder);
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, boolean isTrashed) {
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel doc) {
    }

    private static class Count {
        public long childrenCount = 0L;
        public long descendantsCount = 0L;

        private Count() {
        }
    }
}

