/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.recordlion;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class Constants {
    private static final Log log = LogFactory.getLog(Constants.class);
    public static final String CONF_KEY_BASE_URL = "nuxeo.recordlion.baseurl";
    public static final String CONF_KEY_LOGIN = "nuxeo.recordlion.login";
    public static final String CONF_KEY_PASSWORD = "nuxeo.recordlion.password";
    public static final String CONF_KEY_DEFAULT_RECORDCLASSID = "nuxeo.recordlion.defaultRecordClassId";
    public static final int RECORDSTATE_NEW_OR_MODIFIED = 0;
    public static final int RECORDSTATE_REMOVED = 0;
    public static final String POST_RECORDIZERS = "/api/v1/recordization";
    public static final String DELETE_ONE_RECORD = "/api/v1/recordization?uri=%s";
    public static final String GET_RECORDCLASSES_ALL = "/api/v1/recordclasses?all=true&page=0&pageSize=10";
    public static final String GET_RECORDCLASSES_CONTAINING_TITLEORCODE = "/api/v1/recordclasses?titleOrCode=%s&page=0&pageSize=1";
    public static final String GET_PENDING_ACTIONITEMS_CONTAINING_RECORDURI = "/api/v1/actionitemspending?recordUri=%s&page=0&pageSize=10";
    public static final String GET_PENDING_ACTIONITEMS_CONTAINING_RECORDTITLEORURI = "/api/v1/actionitemspending?recordTitleOrUri=%s&page=0&pageSize=10";
    public static final String PUT_RECORD_DECLARATION = "/api/v1/records?uri=%s";
    public static final String PUT_RECORD_DECLARATION_WITH_ID = "/api/v1/records?id=%s";
    public static final String PUT_RECORD_DECLARATION_WITH_IDENTIFIER = "/api/v1/records?identifier=%s";
    protected static String baseUrl = null;
    protected static String LOCK = "getUrl_LOCK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrl(DocumentModel doc) {
        if (baseUrl == null) {
            String string = LOCK;
            synchronized (string) {
                if (baseUrl == null) {
                    baseUrl = Framework.getProperty((String)"nuxeo.url");
                    if (StringUtils.isBlank((CharSequence)baseUrl)) {
                        log.warn((Object)"No nuxeo.url property found => hard coding localhost:8080");
                        baseUrl = "http://localhost:8080";
                    }
                    if (!baseUrl.endsWith("/")) {
                        baseUrl = baseUrl + "/";
                    }
                }
            }
        }
        return baseUrl + "ui/#!/doc/" + doc.getId();
    }

    public static enum RecordizePropertyState {
        Default,
        Static,
        Constant;


        public static int toInt(RecordizePropertyState value) {
            switch (value) {
                case Default: {
                    return 0;
                }
                case Static: {
                    return 1;
                }
                case Constant: {
                    return 2;
                }
            }
            return 0;
        }
    }

    public static enum RecordDeclarationState {
        None,
        Declare,
        Undeclare;


        public static int toInt(RecordDeclarationState value) {
            switch (value) {
                case None: {
                    return 0;
                }
                case Declare: {
                    return 1;
                }
                case Undeclare: {
                    return 2;
                }
            }
            return 0;
        }
    }

    public static enum LifecyclePhaseAction {
        None,
        Transfer,
        Workflow,
        DeclareRecord,
        UndeclareRecord,
        DisposeDelete,
        DisposeTransfer,
        Permanent,
        DisposeRecycle;

        private static final LifecyclePhaseAction[] allValues;

        public static LifecyclePhaseAction fromInt(int n) {
            return allValues[n];
        }

        static {
            allValues = LifecyclePhaseAction.values();
        }
    }
}

