/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.recordlion.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import nuxeo.recordlion.service.RecordLionService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="RecordLion.CreateRecord", category="Services", label="RecordLion: Create Record", description="Creates a record in the RecordLion server (setup in nuxeo.conf). Returns the JSON String of the result. The al SHOULD BE ASYNCHRNOUS because it cas take time.")
public class CreateRecord {
    public static final String ID = "RecordLion.CreateRecord";
    @Context
    protected CoreSession session;
    @Context
    protected RecordLionService recordlionservice;
    @Context
    protected OperationContext ctx;
    @Param(name="resultVarName", required=true)
    protected String resultVarName;
    @Param(name="recordClassId", required=false)
    protected Long recordClassId = null;
    @Param(name="isManuallyClassified", required=false)
    protected boolean isManuallyClassified = false;
    @Param(name="timeOutInSeconds", required=false)
    protected int timeOutInSeconds = 0;

    @OperationMethod
    public DocumentModel run(DocumentModel input) throws JsonProcessingException {
        String resultStr = "";
        if (this.recordClassId == null || this.recordClassId == 0L) {
            this.recordClassId = this.recordlionservice.getDefaultRecordClassId();
        }
        try {
            JsonNode node = this.recordlionservice.createRecord(input, this.recordClassId, this.isManuallyClassified, this.timeOutInSeconds);
            ObjectMapper mapper = new ObjectMapper();
            resultStr = mapper.writeValueAsString((Object)node);
        }
        catch (IOException e) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.put("result", "KO");
            result.put("message", e.getMessage());
            resultStr = mapper.writeValueAsString((Object)result);
        }
        this.ctx.put(this.resultVarName, (Object)resultStr);
        return input;
    }
}

