/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.recordlion.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import nuxeo.recordlion.Constants;
import nuxeo.recordlion.service.RecordizeProperty;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

public class Record {
    public static final int DEFAULT_FILE_SIZE = 0;
    protected static final String LOCK = "Recordize_lock";
    protected DocumentModel doc;

    public Record(DocumentModel doc) {
        this.doc = doc;
    }

    public JsonNode build(JsonNode propertiesToAppend, String forcedUri) {
        Blob blob;
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode obj = mapper.createObjectNode();
        obj.put("@created", this.getISODate((Calendar)this.doc.getPropertyValue("dc:created")));
        Blob blob2 = blob = this.doc.hasSchema("file") ? (Blob)this.doc.getPropertyValue("file:content") : null;
        if (blob != null) {
            obj.put("@file", blob.getDigest());
            obj.put("@filesize", blob.getLength());
        } else {
            obj.put("@file", this.doc.getId());
            obj.put("@filesize", 0);
        }
        obj.put("@folder", "Folder");
        obj.put("@modified", this.getISODate((Calendar)this.doc.getPropertyValue("dc:created")));
        obj.put("@repo", "nuxeo");
        String uri = StringUtils.isNotBlank((CharSequence)forcedUri) ? forcedUri : Constants.getUrl(this.doc);
        obj.put("@uri", uri);
        if (propertiesToAppend != null) {
            obj.setAll((ObjectNode)propertiesToAppend);
        }
        return obj;
    }

    public ArrayNode buildAsRecordizePropertyArray(JsonNode propertiesToAppend, String forcedUri) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode array = mapper.createArrayNode();
        ObjectNode props = (ObjectNode)this.build(propertiesToAppend, forcedUri);
        Iterator it = props.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = props.get(key).asText();
            RecordizeProperty property = new RecordizeProperty(key, value);
            ObjectNode propertyJson = property.build();
            array.add((JsonNode)propertyJson);
        }
        return array;
    }

    protected String getISODate(Calendar date) {
        if (date == null) {
            date = Calendar.getInstance();
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        String isoStr = df.format(date.getTimeInMillis());
        return isoStr;
    }
}

