/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.recordlion.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import nuxeo.recordlion.Constants;
import nuxeo.recordlion.service.Record;
import nuxeo.recordlion.service.RecordDeclaration;
import nuxeo.recordlion.service.RecordLionDescriptor;
import nuxeo.recordlion.service.RecordLionService;
import nuxeo.recordlion.service.Recordize;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RecordLionServiceImpl
extends DefaultComponent
implements RecordLionService {
    private static final Log log = LogFactory.getLog(RecordLionServiceImpl.class);
    public static final int DEFAULT_PULLACTIONS_TIMEOUT_SECONDS = 60;
    protected static final String XP = "configuration";
    protected RecordLionDescriptor config = null;
    protected String basicAuthenticationString;

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (!(contribution instanceof RecordLionDescriptor)) {
                throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        this.config = (RecordLionDescriptor)contribution;
        this.basicAuthenticationString = "Basic " + new String(Base64.encodeBase64((byte[])(this.config.getLogin() + ":" + this.config.getPassword()).getBytes()));
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public RecordLionDescriptor getDescriptor() {
        return this.config;
    }

    @Override
    public JsonNode recordizeDocument(DocumentModel doc, long recordClassId, boolean isManuallyClassified, JsonNode propertiesToAppend) throws IOException {
        Recordize recordize = new Recordize(doc, recordClassId, isManuallyClassified);
        ObjectNode recordizeNode = (ObjectNode)recordize.build();
        String uri = recordizeNode.get("Uri").asText();
        Record rec = new Record(doc);
        ArrayNode recordJson = rec.buildAsRecordizePropertyArray(propertiesToAppend, uri);
        recordizeNode.set("Properties", (JsonNode)recordJson);
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode array = mapper.createArrayNode();
        array.add((JsonNode)recordizeNode);
        String body = mapper.writeValueAsString((Object)array);
        JsonNode result = this.callWithBody("POST", "/api/v1/recordization", body, false);
        array = (ArrayNode)result;
        JsonNode object = array.get(0);
        return object;
    }

    @Override
    public List<Constants.LifecyclePhaseAction> pullActions(DocumentModel doc, String forceUri) throws IOException {
        String endPoint = StringUtils.isBlank((CharSequence)forceUri) ? String.format("/api/v1/actionitemspending?recordTitleOrUri=%s&page=0&pageSize=10", Constants.getUrl(doc)) : String.format("/api/v1/actionitemspending?recordTitleOrUri=%s&page=0&pageSize=10", forceUri);
        System.out.print("pullActions endPoint:\n" + endPoint + "\n");
        JsonNode result = this.callGET(endPoint);
        ArrayList<Constants.LifecyclePhaseAction> actions = new ArrayList<Constants.LifecyclePhaseAction>();
        ArrayNode items = (ArrayNode)result.get("Items");
        items.forEach(obj -> {
            int action = obj.get("Action").asInt();
            actions.add(Constants.LifecyclePhaseAction.fromInt(action));
        });
        return actions;
    }

    @Override
    public JsonNode declareRecordForIdentifier(String recordIdentifier) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        RecordDeclaration recDecl = new RecordDeclaration();
        recDecl.setRecord(Constants.RecordDeclarationState.Declare);
        JsonNode recordDeclarationJson = recDecl.build();
        String body = mapper.writeValueAsString((Object)recordDeclarationJson);
        String endPoint = String.format("/api/v1/records?identifier=%s", recordIdentifier);
        JsonNode result = this.callWithBody("PUT", endPoint, body, true);
        return result;
    }

    @Override
    public JsonNode createRecord(DocumentModel doc, long recordClassId, boolean isManuallyClassified, long timeOutInSeconds) throws IOException {
        JsonNode result = null;
        ObjectNode resordizeJson = (ObjectNode)this.recordizeDocument(doc, recordClassId, isManuallyClassified, null);
        String recordIdentifier = resordizeJson.get("Identifier").asText();
        String uri = resordizeJson.get("Uri").asText();
        String title = resordizeJson.get("Title").asText();
        boolean timedOut = false;
        boolean gotIt = false;
        if (timeOutInSeconds < 10L) {
            timeOutInSeconds = 60L;
        }
        long timeOutMS = timeOutInSeconds * 1000L;
        long startTime = System.currentTimeMillis();
        System.out.println("==========> timeOutMS: " + timeOutMS);
        System.out.println("==========> uri: " + uri);
        do {
            try {
                List<Constants.LifecyclePhaseAction> actions = this.pullActions(null, title);
                gotIt = actions.contains((Object)Constants.LifecyclePhaseAction.DeclareRecord);
                if (gotIt) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timedOut = timeOutMS > 0L && System.currentTimeMillis() - startTime > timeOutMS;
            }
            catch (IOException e) {
                log.error((Object)("Got an error in pullActions(): " + e.getMessage()));
                System.out.println("==========> Got an error in pullActions(): " + e.getMessage());
                if (e.getMessage().equals("Failed connecting to the server with HTTP result code: 404")) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    timedOut = timeOutMS > 0L && System.currentTimeMillis() - startTime > timeOutMS;
                    continue;
                }
                throw e;
            }
        } while (!gotIt && !timedOut);
        if (gotIt) {
            result = this.declareRecordForIdentifier(recordIdentifier);
            ((ObjectNode)result).put("result", "OK");
        } else {
            ObjectMapper mapper = new ObjectMapper();
            result = mapper.readTree("{\"result\":\"KO\"}");
        }
        ((ObjectNode)result).put("uri", uri);
        ((ObjectNode)result).put("title", title);
        ((ObjectNode)result).put("recordIdentifier", recordIdentifier);
        return result;
    }

    @Override
    public JsonNode deleteRecord(DocumentModel doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode callGET(String api) throws IOException {
        JsonNode node;
        block17: {
            node = null;
            String urlStr = this.buildUrl(api);
            URL url = new URL(urlStr);
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                this.addDefaultHeaders(connection);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (InputStream stream = connection.getInputStream();){
                        String jsonStr = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        ObjectMapper mapper = new ObjectMapper();
                        node = mapper.readTree(jsonStr);
                        break block17;
                    }
                }
                throw new IOException("Failed connecting to the server with HTTP result code: " + responseCode);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode callWithBody(String httpVerb, String api, String body, boolean noResponseExpected) throws IOException {
        JsonNode node;
        block19: {
            if (StringUtils.isBlank((CharSequence)httpVerb) || !httpVerb.equals("POST") && !httpVerb.equals("PUT")) {
                throw new IllegalArgumentException("Invalid http verb");
            }
            node = null;
            String urlStr = this.buildUrl(api);
            URL url = new URL(urlStr);
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                this.addDefaultHeaders(connection);
                connection.setRequestMethod(httpVerb);
                connection.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.writeBytes(body);
                wr.flush();
                wr.close();
                ObjectMapper mapper = new ObjectMapper();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (InputStream stream = connection.getInputStream();){
                        String jsonStr = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        node = mapper.readTree(jsonStr);
                        break block19;
                    }
                }
                if (noResponseExpected && responseCode == 204) {
                    ObjectNode obj = mapper.createObjectNode();
                    obj.put("result", "OK");
                    obj.put("responseCode", responseCode);
                    node = obj;
                    break block19;
                }
                throw new IOException("Failed connecting to the server with HTTP result code: " + responseCode);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return node;
    }

    @Override
    public long getDefaultRecordClassId() {
        return this.config.getDefaultRecordClassId();
    }

    protected String buildUrl(String api) {
        if (!api.startsWith("/")) {
            api = "/" + api;
        }
        return this.config.getBaseUrl() + api;
    }

    protected void addDefaultHeaders(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", this.basicAuthenticationString);
        connection.setRequestProperty("Content-Type", "application/json");
    }
}

