/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.recordlion.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import nuxeo.recordlion.Constants;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;

public class Recordize {
    protected DocumentModel doc;
    protected String uri;
    protected int state;
    protected String title;
    protected String description;
    protected long recordClassId;
    protected boolean IsManuallyClassified;

    public Recordize(DocumentModel doc, long recordClassId, boolean isManuallyClassified) {
        this.doc = doc;
        this.uri = Constants.getUrl(doc);
        this.state = 0;
        this.title = doc.getTitle();
        this.description = "";
        this.recordClassId = recordClassId;
        this.IsManuallyClassified = isManuallyClassified;
    }

    public void setDescription(String description) {
        this.description = StringUtils.isBlank((CharSequence)description) ? "Nuxeo Document" : description;
    }

    public JsonNode build() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode obj = mapper.createObjectNode();
        obj.put("State", this.state);
        obj.put("Title", this.title);
        obj.put("Uri", this.uri);
        obj.put("Description", this.description);
        if (this.IsManuallyClassified) {
            obj.put("RecordClassId", this.recordClassId);
        }
        obj.put("IsManuallyClassified", this.IsManuallyClassified);
        obj.put("isRecord", true);
        return obj;
    }
}

