/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.webengine.WebException;

public abstract class DirectorySessionRunner<T> {
    abstract T run(Session var1) throws ClientException;

    public static <T> T withDirectorySession(Directory directory, DirectorySessionRunner<T> runner) {
        Session session = null;
        try {
            session = directory.getSession();
            T t = runner.run(session);
            return t;
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (DirectoryException e) {
                    throw WebException.wrap((Throwable)e);
                }
            }
        }
    }
}

