/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.usermanager;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.impl.NuxeoGroupImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class NuxeoGroupReader
implements MessageBodyReader<NuxeoGroup> {
    @Context
    JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return NuxeoGroup.class.isAssignableFrom(type);
    }

    public NuxeoGroup readFrom(Class<NuxeoGroup> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        return this.readRequest(content, httpHeaders);
    }

    private NuxeoGroup readRequest(String json, MultivaluedMap<String, String> httpHeaders) {
        try {
            JsonParser jp = this.factory.createJsonParser(json);
            return this.readJson(jp, httpHeaders);
        }
        catch (IOException | ClientException e) {
            throw new WebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private NuxeoGroup readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders) throws JsonParseException, IOException, ClientException {
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        String id = null;
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        NuxeoGroup group = null;
        while (tok != JsonToken.END_OBJECT) {
            String entityType;
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("groupname".equals(key)) {
                id = (String)jp.readValueAs(String.class);
                group = um.getGroup(id);
                if (group == null) {
                    group = new NuxeoGroupImpl(id);
                }
            } else if ("grouplabel".equals(key)) {
                group.setLabel((String)jp.readValueAs(String.class));
            } else if ("memberUsers".equals(key)) {
                tok = jp.nextToken();
                ArrayList<Object> users = new ArrayList<Object>();
                while (tok != JsonToken.END_ARRAY) {
                    users.add(jp.readValueAs(String.class));
                    tok = jp.nextToken();
                }
                group.setMemberUsers(users);
            } else if ("memberGroups".equals(key)) {
                tok = jp.nextToken();
                ArrayList<Object> groups = new ArrayList<Object>();
                while (tok != JsonToken.END_ARRAY) {
                    groups.add(jp.readValueAs(String.class));
                    tok = jp.nextToken();
                }
                group.setMemberGroups(groups);
            } else if ("entity-type".equals(key) && !"group".equals(entityType = (String)jp.readValueAs(String.class))) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            tok = jp.nextToken();
        }
        return group;
    }
}

