/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.PaginablePageProvider;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

public abstract class PaginableAdapter<T>
extends DefaultAdapter {
    protected Long currentPageIndex;
    protected Long pageSize;
    protected String maxResults;

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpServletRequest request = this.ctx.getRequest();
        this.currentPageIndex = this.extractLongParam(request, "currentPageIndex", 0L);
        this.pageSize = this.extractLongParam(request, "pageSize", 50L);
        this.maxResults = request.getParameter("maxResults");
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(DocumentModelList.class)) {
            try {
                return adapter.cast(this.getPaginableEntries());
            }
            catch (ClientException e) {
                return null;
            }
        }
        return (A)super.getAdapter(adapter);
    }

    protected abstract PageProviderDefinition getPageProviderDefinition();

    protected Object[] getParams() {
        return new Object[0];
    }

    protected DocumentModel getSearchDocument() throws ClientException {
        return null;
    }

    @GET
    public Paginable<T> getPaginableEntries() throws ClientException {
        PageProviderDefinition ppDefinition = this.getPageProviderDefinition();
        if (ppDefinition == null) {
            throw new ClientException("Page provider given not found");
        }
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        return this.getPaginableEntries(pps.getPageProvider("", ppDefinition, this.getSearchDocument(), null, this.pageSize, this.currentPageIndex, props, this.getParams()));
    }

    protected Paginable<T> getPaginableEntries(PageProvider<T> pageProvider) {
        return new PaginablePageProvider(pageProvider);
    }

    protected Long extractLongParam(HttpServletRequest request, String paramName, Long defaultValue) {
        String strParam = request.getParameter(paramName);
        return strParam == null ? defaultValue : Long.parseLong(strParam);
    }
}

