/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl;

import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public class CallContextImpl
implements CallContext {
    private final String binding;
    private final boolean objectInfoRequired;
    private final Map<String, Object> parameter = new HashMap<String, Object>();

    public CallContextImpl(String binding, CmisVersion cmisVersion, String repositoryId, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, CmisServiceFactory factory, ThresholdOutputStreamFactory streamFactory) {
        this.binding = binding;
        this.objectInfoRequired = "atompub".equals(binding);
        this.put("repositoryId", repositoryId);
        this.put("cmisVersion", cmisVersion);
        this.put("servletContext", servletContext);
        this.put("httpServletRequest", request);
        this.put("httpServletResponse", response);
        if (streamFactory != null) {
            this.put("tempDir", streamFactory.getTempDir());
            this.put("memoryThreshold", streamFactory.getMemoryThreshold());
            this.put("maxContentSize", streamFactory.getMaxContentSize());
            this.put("encryptTempFiles", streamFactory.isEncrypted());
            this.put("streamFactory", streamFactory);
        } else if (factory != null) {
            this.put("tempDir", factory.getTempDirectory());
            this.put("memoryThreshold", factory.getMemoryThreshold());
            this.put("maxContentSize", -1);
            this.put("encryptTempFiles", false);
        }
    }

    public void setRange(String rangeHeader) {
        if (rangeHeader == null) {
            return;
        }
        if ((rangeHeader = rangeHeader.trim().toLowerCase(Locale.ENGLISH)).length() > 6 && rangeHeader.startsWith("bytes=") && rangeHeader.indexOf(44) == -1 && rangeHeader.charAt(6) != '-') {
            BigInteger offset = null;
            BigInteger length = null;
            int ds = rangeHeader.indexOf(45);
            if (ds > 6) {
                try {
                    String firstBytePosStr = rangeHeader.substring(6, ds);
                    if (firstBytePosStr.length() > 0) {
                        offset = new BigInteger(firstBytePosStr);
                    }
                    if (!rangeHeader.endsWith("-")) {
                        String lastBytePosStr = rangeHeader.substring(ds + 1);
                        length = offset == null ? new BigInteger(lastBytePosStr).add(BigInteger.ONE) : new BigInteger(lastBytePosStr).subtract(offset).add(BigInteger.ONE);
                    }
                    if (offset != null) {
                        this.put("offset", offset);
                    }
                    if (length != null) {
                        this.put("length", length);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    public void setAcceptLanguage(String acceptLanguageHeader) {
        if (acceptLanguageHeader == null) {
            return;
        }
        String[] locale = acceptLanguageHeader.split("-");
        this.put("language", locale[0].trim());
        if (locale.length > 1) {
            int x = locale[1].indexOf(44);
            if (x == -1) {
                this.put("country", locale[1].trim());
            } else {
                this.put("country", locale[1].substring(0, x).trim());
            }
        }
    }

    public String getBinding() {
        return this.binding;
    }

    public boolean isObjectInfoRequired() {
        return this.objectInfoRequired;
    }

    public Object get(String key) {
        return this.parameter.get(key);
    }

    public CmisVersion getCmisVersion() {
        return (CmisVersion)this.get("cmisVersion");
    }

    public String getRepositoryId() {
        return (String)this.get("repositoryId");
    }

    public String getUsername() {
        return (String)this.get("username");
    }

    public String getPassword() {
        return (String)this.get("password");
    }

    public String getLocale() {
        return (String)this.get("locale");
    }

    public BigInteger getOffset() {
        return (BigInteger)this.get("offset");
    }

    public BigInteger getLength() {
        return (BigInteger)this.get("length");
    }

    public File getTempDirectory() {
        return (File)this.get("tempDir");
    }

    public boolean encryptTempFiles() {
        return Boolean.TRUE.equals(this.get("encryptTempFiles"));
    }

    public int getMemoryThreshold() {
        return (Integer)this.get("memoryThreshold");
    }

    public long getMaxContentSize() {
        return (Long)this.get("maxContentSize");
    }

    public void put(String key, Object value) {
        this.parameter.put(key, value);
    }

    public Object remove(String key) {
        return this.parameter.remove(key);
    }
}

