/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeContainer;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort")
public class RepositoryService
extends AbstractService
implements RepositoryServicePort {
    @Resource
    public WebServiceContext wsContext;

    public List<CmisRepositoryEntryType> getRepositories(CmisExtensionType extension) throws CmisException {
        ArrayList<CmisRepositoryEntryType> arrayList;
        List infoDataList;
        CmisService service;
        block6: {
            service = null;
            service = this.getService(this.wsContext, null);
            infoDataList = service.getRepositoryInfos(WSConverter.convert((CmisExtensionType)extension));
            if (infoDataList != null) break block6;
            List<CmisRepositoryEntryType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisRepositoryEntryType> result = new ArrayList<CmisRepositoryEntryType>();
            for (RepositoryInfo infoData : infoDataList) {
                CmisRepositoryEntryType entry = new CmisRepositoryEntryType();
                entry.setRepositoryId(infoData.getId());
                entry.setRepositoryName(infoData.getName());
                result.add(entry);
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisRepositoryInfoType getRepositoryInfo(String repositoryId, CmisExtensionType extension) throws CmisException {
        CmisRepositoryInfoType cmisRepositoryInfoType;
        CmisService service = null;
        CmisVersion cmisVersion = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisVersion = this.getCmisVersion(this.wsContext);
            cmisRepositoryInfoType = WSConverter.convert((RepositoryInfo)service.getRepositoryInfo(repositoryId, WSConverter.convert((CmisExtensionType)extension)), (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisRepositoryInfoType;
    }

    public CmisTypeDefinitionListType getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionListType cmisTypeDefinitionListType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisTypeDefinitionListType = WSConverter.convert((TypeDefinitionList)service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, WSConverter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionListType;
    }

    public CmisTypeDefinitionType getTypeDefinition(String repositoryId, String typeId, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionType cmisTypeDefinitionType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisTypeDefinitionType = WSConverter.convert((TypeDefinition)service.getTypeDefinition(repositoryId, typeId, WSConverter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionType;
    }

    public List<CmisTypeContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisTypeContainer> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisTypeContainer> result = new ArrayList<CmisTypeContainer>();
            WSConverter.convertTypeContainerList((List)service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, WSConverter.convert((CmisExtensionType)extension)), result);
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public void createType(String repositoryId, Holder<CmisTypeDefinitionType> type, CmisExtensionType extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            type.value = WSConverter.convert((TypeDefinition)service.createType(repositoryId, WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)type.value)), WSConverter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void updateType(String repositoryId, Holder<CmisTypeDefinitionType> type, CmisExtensionType extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            type.value = WSConverter.convert((TypeDefinition)service.updateType(repositoryId, WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)type.value)), WSConverter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteType(String repositoryId, String typeId, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = WSConverter.convertExtensionHolder(extension);
            service.deleteType(repositoryId, typeId, extData);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }
}

