/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.http;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.http.HTTPClientDescriptor;
import org.nuxeo.ecm.automation.http.HTTPClientService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class HTTPClientComponent
extends DefaultComponent
implements HTTPClientService {
    static final Log log = LogFactory.getLog(HTTPClientComponent.class);
    public static final String EP_CLIENT = "client";
    protected HTTPClientDescriptor desc;
    protected Client client;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.getClient();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.client = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_CLIENT.equals(extensionPoint)) {
            this.desc = (HTTPClientDescriptor)contribution;
        }
    }

    @Override
    public Client getClient() {
        if (this.client == null) {
            DefaultClientConfig cc = new DefaultClientConfig();
            if (this.desc != null) {
                Map feats = cc.getFeatures();
                Map props = cc.getProperties();
                Map<String, String> propCfg = this.desc.getProperties();
                if (propCfg != null) {
                    for (Map.Entry<String, String> kv : propCfg.entrySet()) {
                        String key = kv.getKey();
                        if (key.contains("Size") || key.contains("Timeout")) {
                            props.put(key, Integer.parseInt(kv.getValue()));
                            continue;
                        }
                        props.put(key, Boolean.parseBoolean(kv.getValue()));
                    }
                }
                if ((propCfg = this.desc.getFeatures()) != null) {
                    for (Map.Entry<String, String> kv : propCfg.entrySet()) {
                        feats.put(kv.getKey(), Boolean.parseBoolean(kv.getValue()));
                    }
                }
            }
            this.client = Client.create((ClientConfig)cc);
            if (this.desc != null) {
                List<String> clsNames = this.desc.getFilters();
                for (String cls : clsNames) {
                    try {
                        Class<?> filter = Class.forName(cls);
                        this.client.addFilter((ClientFilter)filter.newInstance());
                    }
                    catch (Exception ex) {
                        log.error((Object)("Error loading HTTP client filter: " + cls), (Throwable)ex);
                    }
                }
            }
        }
        return this.client;
    }
}

