/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.header.ContentDisposition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.http.HTTPBlobWrapper;
import org.nuxeo.ecm.automation.http.HTTPClientService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Blob.HTTPMethod", category="Files", label="HTTP Method", description="Invoke a RESTful HTTP Method.")
public class HTTPMethod {
    public static final String ID = "Blob.HTTPMethod";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService automation;
    @Param(name="method", description="HTTP Method", required=false, widget="Option", values={"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"})
    String method = "GET";
    @Param(name="url", description="Target URL", required=true)
    protected String url;
    @Param(name="headerMap", description="Headers as a Map", required=false)
    protected Properties headerMap;
    @Param(name="headers", description="Headers as JSON", required=false)
    protected String headerJSON;
    @Param(name="paramMap", description="Query parameters as a Map", required=false)
    protected Properties paramMap;
    @Param(name="params", description="Query parameters as JSON", required=false)
    protected String paramJSON;
    @Param(name="body", description="Body to send", required=false)
    protected String body;
    @Param(name="contentType", description="'Content-Type' request header", required=false)
    protected String contentType;
    @Param(name="accept", description="'Accept' header MIME Type", required=false)
    protected String accept = "*/*";
    @Param(name="download", description="Create Blob from response", required=false)
    protected boolean download = false;

    protected Client getClient() {
        HTTPClientService service = (HTTPClientService)Framework.getService(HTTPClientService.class);
        return service.getClient();
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(DocumentModel doc) throws Exception {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return this.run(bh.getBlob());
    }

    @OperationMethod
    public Blob run() throws IOException, OperationException {
        return this.run((Blob)null);
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob blob) throws IOException, OperationException {
        WebResource resource = this.getClient().resource(this.url);
        this.addParams(resource, this.paramMap, this.paramJSON);
        WebResource.Builder builder = resource.accept(new String[]{this.accept});
        this.addHeaders(builder, this.headerMap, this.headerJSON);
        if ("PUT".equals(this.method) || "POST".equals(this.method)) {
            if (this.body != null) {
                if (this.contentType == null) {
                    this.contentType = "text/plain";
                }
                if (this.contentType != null) {
                    builder.type(this.contentType);
                }
                builder.entity((Object)this.body);
            } else if (blob != null) {
                if (this.contentType == null && blob.getMimeType() != null) {
                    this.contentType = blob.getMimeType();
                }
                if (this.contentType != null) {
                    builder.type(this.contentType);
                }
                builder.entity((Object)blob.getStream());
            }
        }
        ClientResponse response = null;
        Blob result = null;
        boolean err = false;
        String msg = null;
        int statusCode = 0;
        try {
            response = (ClientResponse)builder.method(this.method, ClientResponse.class);
            if (this.download) {
                String encoding;
                MultivaluedMap respHeaders = response.getHeaders();
                InputStream data = response.getEntityInputStream();
                result = Blobs.createBlob((InputStream)data);
                if (response.getType() != null) {
                    result.setMimeType(response.getType().toString());
                }
                if ((encoding = (String)respHeaders.getFirst((Object)"Content-Encoding")) != null) {
                    result.setEncoding(encoding);
                }
                String filename = null;
                if (respHeaders.containsKey((Object)"Content-Disposition")) {
                    String disp = (String)respHeaders.getFirst((Object)"Content-Disposition");
                    ContentDisposition cdisp = new ContentDisposition(disp);
                    filename = cdisp.getFileName();
                }
                if (StringUtils.isBlank(filename)) {
                    filename = this.url.substring(this.url.lastIndexOf("/") + 1, this.url.length());
                }
                if (StringUtils.isBlank(filename)) {
                    filename = "DownloadedFile-" + UUID.randomUUID().toString();
                }
                result.setFilename(filename);
            } else {
                result = Blobs.createBlob((String)((String)response.getEntity(String.class)), (String)"text/plain", (String)"UTF-8");
            }
        }
        catch (UniformInterfaceException ufe) {
            err = true;
            msg = ufe.getMessage();
            throw new NuxeoException(ufe.getMessage(), (Throwable)ufe, ufe.getResponse().getStatus());
        }
        catch (Exception e) {
            err = true;
            msg = e.getMessage();
            throw new NuxeoException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                Response.StatusType status = response.getStatusInfo();
                statusCode = status.getStatusCode();
                response.close();
            }
        }
        HTTPBlobWrapper wrap = new HTTPBlobWrapper(response, result);
        wrap.setError(err);
        wrap.setMessage(msg);
        wrap.setStatus(statusCode);
        return wrap;
    }

    protected void addHeaders(WebResource.Builder inHttp, Properties inProps, String inJsonStr) throws IOException {
        if (inProps != null) {
            inProps.stringPropertyNames().stream().forEach(h -> {
                WebResource.Builder cfr_ignored_0 = (WebResource.Builder)inHttp.header(h, (Object)inProps.getProperty((String)h));
            });
        }
        if (StringUtils.isNotBlank((CharSequence)inJsonStr)) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(inJsonStr);
            Iterator it = rootNode.fieldNames();
            while (it.hasNext()) {
                String oneHeader = (String)it.next();
                inHttp.header(oneHeader, (Object)rootNode.get(oneHeader).textValue());
            }
        }
    }

    protected void addParams(WebResource inHttp, Properties inProps, String inJsonStr) throws IOException {
        if (inProps != null) {
            inProps.stringPropertyNames().stream().forEach(h -> inHttp.queryParam(h, inProps.getProperty((String)h)));
        }
        if (StringUtils.isNotBlank((CharSequence)inJsonStr)) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(inJsonStr);
            Iterator it = rootNode.fieldNames();
            while (it.hasNext()) {
                String oneHeader = (String)it.next();
                inHttp.queryParam(oneHeader, rootNode.get(oneHeader).textValue());
            }
        }
    }
}

