/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;

@Operation(id="S3Utils.Delete", category="Files", label="S3 Utils: Delete", description="Deletes a file from S3, using S3Handler <code>handlerName</code> (if empty, uses the default handler). Sets a new context variable, s3UtilsDeletionResult to true/false. If <code>bucket</code> is empty, uses the bucket set in the handler configuration")
public class S3DeleteOp {
    public static final String ID = "S3Utils.Delete";
    public static final String RESULT_CONTEXT_VAR_NAME = "s3UtilsDeletionResult";
    @Context
    protected OperationContext ctx;
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="bucket", required=false)
    protected String bucket;
    @Param(name="key", required=true)
    protected String key;

    @OperationMethod
    public void run() throws NuxeoException, IOException {
        boolean result;
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        S3Handler s3Handler = S3Handler.getS3Handler(this.handlerName);
        if (StringUtils.isNotBlank((CharSequence)this.bucket)) {
            s3Handler.setBucket(this.bucket);
        }
        this.ctx.put(RESULT_CONTEXT_VAR_NAME, (Object)((result = s3Handler.deleteFile(this.key)) ? "true" : "false"));
    }
}

