/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;

@Operation(id="S3Utils.Download", category="Files", label="S3 Utils: Download", description="Downloads a file from S3, using S3Handler <code>handlerName</code> (if empty, uses the default handler). If <code>bucket</code> is empty, uses the bucket set in the handler configuration")
public class S3DownloadOp {
    public static final String ID = "S3Utils.Download";
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="bucket", required=false)
    protected String bucket;
    @Param(name="key", required=true)
    protected String key;

    @OperationMethod
    public Blob run() throws NuxeoException, IOException {
        Blob result = null;
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        S3Handler s3Handler = S3Handler.getS3Handler(this.handlerName);
        if (StringUtils.isNotBlank((CharSequence)this.bucket)) {
            s3Handler.setBucket(this.bucket);
        }
        result = s3Handler.downloadFile(this.key, (String)null);
        return result;
    }
}

