/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.AWSConfigurationService;

@XObject(value="s3Handler")
public class S3HandlerDescriptor {
    @XNode(value="name")
    protected String name = "";
    @XNode(value="class")
    protected Class<?> klass;
    @XNode(value="region")
    protected String region = "";
    @XNode(value="bucket")
    protected String bucket = "";
    @XNode(value="tempSignedUrlDuration")
    protected String tempSignedUrlDuration = "";
    @XNode(value="useCacheForExistsKey")
    protected String useCacheForExistsKey = "false";
    @XNode(value="minimumUploadPartSize")
    protected Long minimumUploadPartSize = 0L;
    @XNode(value="multipartUploadThreshold")
    protected Long multipartUploadThreshold = 0L;
    protected int signedUrlDuration = -1;
    protected int useExistsKeyCache = -1;
    protected TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();

    public String getName() {
        return this.name;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public String getRegion() {
        System.out.println("REGION 1: " + this.region);
        if (StringUtils.isBlank((CharSequence)this.region)) {
            this.region = Framework.getProperty((String)"nuxeo.aws.s3utils.region");
            System.out.println("REGION 2: " + this.region);
            if (StringUtils.isBlank((CharSequence)this.region)) {
                this.region = ((AWSConfigurationService)Framework.getService(AWSConfigurationService.class)).getAWSRegion();
            }
            System.out.println("REGION 3: " + this.region);
            if (StringUtils.isBlank((CharSequence)this.region)) {
                Framework.getProperty((String)"nuxeo.aws.region");
            }
        }
        System.out.println("REGION FINAL: " + this.region);
        return this.region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public boolean useCacheForExistsKey() {
        if (this.useExistsKeyCache < 0) {
            this.useExistsKeyCache = StringUtils.isNotBlank((CharSequence)this.useCacheForExistsKey) && "true".equals(this.useCacheForExistsKey.toLowerCase()) ? 1 : 0;
        }
        return this.useExistsKeyCache == 1;
    }

    public int getTempSignedUrlDuration() {
        if (this.signedUrlDuration < 0) {
            if (!this.tempSignedUrlDuration.isEmpty()) {
                try {
                    this.signedUrlDuration = (int)Long.parseLong(this.tempSignedUrlDuration);
                }
                catch (NumberFormatException e) {
                    this.signedUrlDuration = -1;
                }
            }
            if (this.signedUrlDuration < 0) {
                this.signedUrlDuration = 1200;
            }
        }
        return this.signedUrlDuration;
    }

    public long getMinimumUploadPartSize() {
        if (this.minimumUploadPartSize == 0L) {
            this.minimumUploadPartSize = this.transferManagerConfiguration.getMinimumUploadPartSize();
        }
        return this.minimumUploadPartSize;
    }

    public long getMultipartUploadThreshold() {
        if (this.multipartUploadThreshold == 0L) {
            this.multipartUploadThreshold = this.transferManagerConfiguration.getMultipartUploadThreshold();
        }
        return this.multipartUploadThreshold;
    }
}

