/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.common.file.LRUFileCache;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.convert.ConvertHelper;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.s3utils.BlobKey;
import org.nuxeo.s3utils.S3Handler;

public class S3UtilsBlobProvider
extends AbstractBlobProvider {
    protected static final Log log = LogFactory.getLog(S3UtilsBlobProvider.class);
    public static final String NO_DEFAULT_DOWNLOAD_ABOVE_PROPERTY = "noDefaultDownloadAbove";
    public static final String CACHE_SIZE_PROPERTY = "cacheSize";
    public static final String CACHE_COUNT_PROPERTY = "cacheCount";
    public static final String CACHE_MIN_AGE_PROPERTY = "cacheMinAge";
    public static final String S3_HANDLER_ATTACHED_PROPERTY = "s3Handler";
    protected S3Handler s3Handler;
    protected File cachedir;
    public FileCache fileCache;
    protected long maxForDefaultDownload;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        String s3HandlerAttached = properties.getOrDefault(S3_HANDLER_ATTACHED_PROPERTY, "default");
        this.s3Handler = S3Handler.getS3Handler(s3HandlerAttached);
        if (this.s3Handler == null) {
            throw new NuxeoException("Cannot initialize the S3UtilsBlobProvider because the related S3Handler named '" + s3HandlerAttached + "' was not found.");
        }
        String cacheSizeStr = properties.getOrDefault(CACHE_SIZE_PROPERTY, "100 mb");
        String cacheCountStr = properties.getOrDefault(CACHE_COUNT_PROPERTY, "10000");
        String minAgeStr = properties.getOrDefault(CACHE_MIN_AGE_PROPERTY, "3600");
        this.initializeCache(SizeUtils.parseSizeInBytes((String)cacheSizeStr), Long.parseLong(cacheCountStr), Long.parseLong(minAgeStr));
        String maxForDefaultDownloadStr = properties.getOrDefault(NO_DEFAULT_DOWNLOAD_ABOVE_PROPERTY, "0");
        this.maxForDefaultDownload = Long.parseLong(maxForDefaultDownloadStr);
    }

    public void close() {
        this.fileCache.clear();
        if (this.cachedir != null) {
            try {
                FileUtils.deleteDirectory((File)this.cachedir);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        if (blobInfo == null || blobInfo.key == null) {
            throw new IOException("Invalid blobinfo: " + blobInfo);
        }
        BlobKey blobKey = new BlobKey(this.blobProviderId, blobInfo.key, this.s3Handler.getBucket());
        String objectKey = blobKey.getObjectKey();
        BlobInfo fetchedInfo = this.buildBlobInfoForObject(objectKey);
        blobInfo.length = fetchedInfo.length;
        blobInfo.digest = fetchedInfo.digest;
        blobInfo.encoding = fetchedInfo.encoding;
        blobInfo.mimeType = fetchedInfo.mimeType;
        blobInfo.filename = fetchedInfo.filename;
        return new SimpleManagedBlob(blobInfo);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        File cachedFile = this.getFileFromCache(blob);
        return new FileInputStream(cachedFile);
    }

    public File getFile(ManagedBlob blob) {
        File f = null;
        try {
            f = this.getFileFromCache(blob);
            Object path = FilenameUtils.getPath((String)f.getAbsolutePath());
            if (((String)path).lastIndexOf("/") < 0) {
                path = (String)path + "/";
            }
            Path source = Paths.get(f.getAbsolutePath(), new String[0]);
            Path result = Files.move(source, source.resolveSibling(blob.getFilename()), StandardCopyOption.REPLACE_EXISTING);
            f = new File(result.toString());
        }
        catch (IOException e) {
            throw new NuxeoException("Erreur getting a file for blob key " + blob.getKey(), (Throwable)e);
        }
        return f;
    }

    public SequenceInputStream getSequenceInputStream(ManagedBlob blob) throws IOException {
        BlobKey blobKey = new BlobKey(this.blobProviderId, blob.getKey(), this.s3Handler.getBucket());
        String objectKey = blobKey.getObjectKey();
        SequenceInputStream stream = this.s3Handler.getSequenceInputStream(objectKey, 0L);
        return stream;
    }

    public byte[] readBytes(ManagedBlob blob, long start, long len) throws IOException {
        BlobKey blobKey = new BlobKey(this.blobProviderId, blob.getKey(), this.s3Handler.getBucket());
        String objectKey = blobKey.getObjectKey();
        return this.s3Handler.readBytes(objectKey, start, len);
    }

    public String writeBlob(Blob blob) throws IOException {
        throw new UnsupportedOperationException("Write not supported");
    }

    public boolean supportsUserUpdate() {
        return false;
    }

    protected void initializeCache(long maxSize, long maxCount, long minAge) throws IOException {
        this.cachedir = Framework.createTempFile((String)"s3utilsblobprovider.", (String)"");
        this.cachedir.delete();
        this.cachedir.mkdir();
        this.fileCache = new LRUFileCache(this.cachedir, maxSize, maxCount, minAge);
    }

    protected File getFileFromCache(ManagedBlob blob) throws IOException {
        BlobKey blobKey = new BlobKey(this.blobProviderId, blob.getKey(), this.s3Handler.getBucket());
        String objectKey = blobKey.getObjectKey();
        ObjectMetadata metadata = this.s3Handler.getObjectMetadata(objectKey);
        String etag = metadata.getETag();
        File cachedFile = this.fileCache.getFile(etag);
        if (cachedFile == null) {
            File tmp = this.fileCache.getTempFile();
            if (this.maxForDefaultDownload <= 0L || metadata.getContentLength() <= this.maxForDefaultDownload) {
                this.s3Handler.downloadFile(objectKey, tmp);
            } else {
                this.buildFileWithObjectInfo(objectKey, metadata, tmp);
            }
            this.fileCache.putFile(etag, tmp);
            cachedFile = this.fileCache.getFile(etag);
        }
        return cachedFile;
    }

    public S3Handler getS3Handler() {
        return this.s3Handler;
    }

    public ManagedBlob createBlobFromObjectKey(String objectKey) throws IOException {
        BlobInfo info = this.buildBlobInfoForObject(objectKey);
        return new SimpleManagedBlob(info);
    }

    protected BlobInfo buildBlobInfoForObject(String objectKey) {
        BlobInfo info = new BlobInfo();
        ObjectMetadata metadata = this.s3Handler.getObjectMetadata(objectKey);
        info.key = BlobKey.buildFullKey(this.blobProviderId, this.s3Handler.getBucket(), objectKey);
        info.length = metadata.getContentLength();
        info.digest = metadata.getContentMD5();
        info.encoding = metadata.getContentEncoding();
        info.mimeType = metadata.getContentType();
        info.filename = FilenameUtils.getName((String)objectKey);
        return info;
    }

    protected File buildFileWithObjectInfo(String objectKey, ObjectMetadata metadata, File toFile) throws IOException {
        Blob converted;
        Object text = "This file is beyond the max. size for download\n\n";
        text = (String)text + FilenameUtils.getName((String)objectKey) + "\n";
        text = (String)text + FileUtils.byteCountToDisplaySize((long)metadata.getContentLength()) + "\n";
        text = (String)text + metadata.getContentType() + "\n";
        MimetypeRegistryService mimeTypeService = (MimetypeRegistryService)Framework.getService(MimetypeRegistry.class);
        Optional mimeTypeOpt = mimeTypeService.getNormalizedMimeType(metadata.getContentType());
        String mimeType = mimeTypeOpt.isEmpty() ? metadata.getContentType() : (String)mimeTypeOpt.get();
        ConvertHelper convertHelper = new ConvertHelper();
        Blob placeHolderBlob = Blobs.createBlob((String)text);
        placeHolderBlob.setFilename(FilenameUtils.getBaseName((String)objectKey) + "-noDownload.txt");
        if (mimeType.startsWith("image/")) {
            Blob placeHolderBlobPdf = convertHelper.convertBlob(placeHolderBlob, "application/pdf");
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            String fileName = FilenameUtils.getBaseName((String)objectKey) + "." + mimeType.split("/")[1];
            params.put("targetFileName", (CallSite)((Object)fileName));
            params.put("targetFilePath", (CallSite)((Object)fileName));
            ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
            BlobHolder holder = conversionService.convert("pdf2image", (BlobHolder)new SimpleBlobHolder(placeHolderBlobPdf), params);
            converted = holder.getBlob();
        } else {
            switch (mimeType) {
                case "application/pdf": {
                    converted = convertHelper.convertBlob(placeHolderBlob, "application/pdf");
                    break;
                }
                case "text/plain": {
                    converted = placeHolderBlob;
                    break;
                }
                default: {
                    try {
                        converted = convertHelper.convertBlob(placeHolderBlob, mimeType);
                        break;
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to convert the place holder text/plain blob to " + mimeType + ", trying to convert it to PDF first, then convert this pdf"), (Throwable)e);
                        try {
                            Blob placeHolderBlobPdf = convertHelper.convertBlob(placeHolderBlob, "application/pdf");
                            converted = convertHelper.convertBlob(placeHolderBlob, mimeType);
                            break;
                        }
                        catch (Exception e2) {
                            log.warn((Object)String.format("Could not generate a blob for object %s, content type %s, normalized to %s: Returning a simple string blob", objectKey, metadata.getContentType(), mimeType), (Throwable)e2);
                            converted = placeHolderBlob;
                        }
                    }
                }
            }
        }
        if (toFile != null) {
            converted.transferTo(toFile);
            return toFile;
        }
        return converted.getFile();
    }

    public long getMaxForDefaultDownload() {
        return this.maxForDefaultDownload;
    }
}

