/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.s3utils.S3HandlerDescriptor;
import org.nuxeo.s3utils.S3HandlerService;
import org.nuxeo.s3utils.S3ObjectStreaming;

public interface S3Handler
extends S3ObjectStreaming {
    public static final long DEFAULT_PIECE_SIZE = 0x6400000L;

    public void initialize(S3HandlerDescriptor var1) throws NuxeoException;

    public void cleanup();

    public void setBucket(String var1);

    public AmazonS3 getS3();

    public boolean sendFile(String var1, File var2) throws NuxeoException;

    public Blob downloadFile(String var1, File var2);

    public Blob downloadFile(String var1, String var2);

    @Override
    public SequenceInputStream getSequenceInputStream(String var1, long var2) throws IOException;

    @Override
    public byte[] readBytes(String var1, long var2, long var4) throws IOException;

    public boolean deleteFile(String var1) throws NuxeoException;

    public String buildPresignedUrl(String var1, int var2, String var3, String var4) throws NuxeoException;

    public String buildPresignedUrl(String var1, String var2, int var3, String var4, String var5) throws NuxeoException;

    public boolean existsKeyInS3(String var1, String var2);

    public boolean existsKeyInS3(String var1);

    public boolean existsKey(String var1);

    public boolean existsKey(String var1, String var2);

    public ObjectMetadata getObjectMetadata(String var1);

    public JsonNode getObjectMetadataJson(String var1) throws JsonProcessingException;

    public String getBucket();

    public int getSignedUrlDuration();

    public static S3Handler getS3Handler(String name) {
        S3HandlerService s3HandlerService = (S3HandlerService)Framework.getService(S3HandlerService.class);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "default";
        }
        return s3HandlerService.getS3Handler(name);
    }

    public static String buildDetailedMessageFromAWSException(Exception e) {
        Object message = "";
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            message = "Caught an AmazonServiceException, which means your request made it to Amazon S3, but was rejected with an error response for some reason.";
            message = (String)message + "\nError Message:    " + ase.getMessage();
            message = (String)message + "\nHTTP Status Code: " + ase.getStatusCode();
            message = (String)message + "\nAWS Error Code:   " + ase.getErrorCode();
            message = (String)message + "\nError Type:       " + ase.getErrorType();
            message = (String)message + "\nRequest ID:       " + ase.getRequestId();
        } else if (e instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)e;
            message = "Caught an AmazonClientException, which means the client encountered an internal error while trying to communicate with S3, such as not being able to access the network.";
            message = (String)message + "\nError Message: " + ace.getMessage();
        } else {
            message = e.getMessage();
        }
        return message;
    }

    public static boolean errorIsMissingKey(AmazonClientException e) {
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            return ase.getStatusCode() == 404 || "NoSuchKey".equals(ase.getErrorCode()) || "Not Found".equals(e.getMessage());
        }
        return false;
    }
}

