/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import java.util.HashMap;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.s3utils.S3Handler;
import org.nuxeo.s3utils.S3HandlerDescriptor;
import org.nuxeo.s3utils.S3HandlerService;

public class S3HandlerServiceImpl
extends DefaultComponent
implements S3HandlerService {
    protected static final String XP = "configuration";
    protected HashMap<String, S3HandlerDescriptor> contributions = new HashMap();
    protected HashMap<String, S3Handler> s3Handlers = new HashMap();

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.contributions.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (!(contribution instanceof S3HandlerDescriptor)) {
                throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        this.registerS3Handler((S3HandlerDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint) && contribution instanceof S3HandlerDescriptor) {
            this.unregisterS3Handler((S3HandlerDescriptor)contribution);
        }
    }

    protected void registerS3Handler(S3HandlerDescriptor desc) {
        this.contributions.put(desc.getName(), desc);
        this.getS3Handler(desc.getName());
    }

    protected void unregisterS3Handler(S3HandlerDescriptor desc) {
        this.contributions.remove(desc.getName());
        S3Handler handler = this.s3Handlers.get(desc.getName());
        if (handler != null) {
            handler.cleanup();
            this.s3Handlers.remove(desc.getName());
        }
    }

    @Override
    public synchronized S3Handler getS3Handler(String name) {
        S3Handler handler = this.s3Handlers.get(name);
        if (handler == null) {
            S3HandlerDescriptor desc = this.contributions.get(name);
            if (desc == null) {
                return null;
            }
            Class<?> klass = desc.klass;
            try {
                if (!S3Handler.class.isAssignableFrom(klass)) {
                    throw new RuntimeException("Unknown class for S3Handler: " + klass);
                }
                Class<?> s3HandlerClass = klass;
                handler = (S3Handler)s3HandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            try {
                handler.initialize(desc);
            }
            catch (NuxeoException e) {
                throw new RuntimeException(e);
            }
            this.s3Handlers.put(name, handler);
        }
        return handler;
    }
}

