/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;
import org.nuxeo.s3utils.S3HandlerServiceImpl;

@Operation(id="S3Utils.Upload", category="Files", label="S3 Utils: Upload", description="Uploads the blob(s) to s3, using S3Handler <code>handlerName</code> (if empty, uses the default handler). If <code>bucket</code> is empty, uses the bucket set in the handler configuration. Returns the input unchanged. If the input is Document(s), uses the blob found in the xpath parameter")
public class S3UploadOp {
    public static final String ID = "S3Utils.Upload";
    @Context
    protected S3HandlerServiceImpl s3HandlerService;
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="bucket", required=false)
    protected String bucket;
    @Param(name="key", required=true)
    protected String key;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath;
    protected S3Handler s3Handler;

    protected void setup() {
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        if (this.s3Handler == null) {
            this.s3Handler = S3Handler.getS3Handler(this.handlerName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bucket)) {
            this.s3Handler.setBucket(this.bucket);
        }
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
    }

    @OperationMethod
    public Blob run(Blob blob) throws NuxeoException, IOException {
        if (blob != null) {
            this.setup();
            File f = blob.getFile();
            if (f != null) {
                boolean bl = this.s3Handler.sendFile(this.key, blob.getFile());
            }
        }
        return blob;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws NuxeoException, IOException {
        if (doc != null) {
            this.setup();
            Blob b = (Blob)doc.getPropertyValue(this.xpath);
            this.run(b);
        }
        return doc;
    }
}

