/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;

public class BlobKey {
    protected String bucket;
    protected String objectKey;
    protected String blobProviderId;

    public static String buildFullKey(String providerId, String bucket, String objectKey) {
        return providerId + ":" + bucket + ":" + objectKey;
    }

    public BlobKey(String blobProviderId, String fullKey) {
        if (StringUtils.isBlank((CharSequence)fullKey) || !fullKey.startsWith(blobProviderId)) {
            throw new NuxeoException(String.format("Blob key (%s) does not match this provider (%s).", fullKey, blobProviderId));
        }
        String[] parts = fullKey.split(":");
        if (parts.length != 3) {
            throw new NuxeoException(String.format("Blob key (%s) is mal formatted. Should be providerId:bucket:objectKey.", fullKey));
        }
        this.bucket = parts[1];
        this.objectKey = parts[2];
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.bucket, this.objectKey})) {
            throw new NuxeoException(String.format("Blob key (%s) is missing bucket and/or object key.", fullKey));
        }
    }

    BlobKey(String blobProviderId, String fullKey, String expectedBucket) {
        this(blobProviderId, fullKey);
        if (!this.bucket.equals(expectedBucket)) {
            throw new NuxeoException(String.format("Bucket (%s) in the key (%s) does not match %s", this.bucket, fullKey, expectedBucket));
        }
    }

    public boolean isValid() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.bucket, this.objectKey});
    }

    public String getProviderId() {
        return this.blobProviderId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public String buildFullKey(String objectKey) {
        return this.blobProviderId + ":" + this.bucket + ":" + objectKey;
    }
}

