/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ObjectSequentialStream
implements Enumeration<S3ObjectInputStream> {
    protected static final Log log = LogFactory.getLog(S3ObjectSequentialStream.class);
    protected AmazonS3 s3;
    protected String objectKey;
    protected String bucket;
    protected long currentPosition = 0L;
    protected long totalSize;
    protected long pieceSize = 0x6400000L;

    public S3ObjectSequentialStream(AmazonS3 s3, String bucket, String objectKey) {
        this(s3, bucket, objectKey, 0L);
    }

    public S3ObjectSequentialStream(AmazonS3 s3, String bucket, String objectKey, long pieceSize) {
        this.s3 = s3;
        this.bucket = bucket;
        this.objectKey = objectKey;
        if (pieceSize > 0L) {
            this.pieceSize = pieceSize;
        }
        ObjectMetadata metadata = s3.getObjectMetadata(bucket, objectKey);
        this.totalSize = metadata.getContentLength();
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentPosition < this.totalSize;
    }

    @Override
    public S3ObjectInputStream nextElement() {
        GetObjectRequest gor = new GetObjectRequest(this.bucket, this.objectKey).withRange(this.currentPosition, this.currentPosition + this.pieceSize - 1L);
        this.currentPosition += this.pieceSize;
        S3ObjectInputStream stream = this.s3.getObject(gor).getObjectContent();
        return stream;
    }

    public SequenceInputStream getInputStream() {
        return new SequenceInputStream(this);
    }
}

