/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;

@Operation(id="S3Utils.KeyExists", category="Files", label="S3 Utils: Key Exists", description="Return a Boolean in a the s3UtilsTempSignedUrl context variable, depending if the key exists in the bucket or not. Set useCache to true to use the cache if the S3Handler configuraiton allows for it.")
public class S3KeyExistsOp {
    public static final String ID = "S3Utils.KeyExists";
    public static final String RESULT_CONTEXT_VAR_NAME = "s3UtilsKeyExists";
    @Context
    protected OperationContext ctx;
    @Param(name="key", required=true)
    protected String key;
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="bucket", required=false)
    protected String bucket;
    @Param(name="useCache", required=false)
    protected Boolean useCache = false;

    @OperationMethod
    public void run() throws NuxeoException, IOException {
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        S3Handler s3Handler = S3Handler.getS3Handler(this.handlerName);
        if (StringUtils.isNotBlank((CharSequence)this.bucket)) {
            s3Handler.setBucket(this.bucket);
        }
        boolean exists = false;
        exists = this.useCache != false ? s3Handler.existsKey(this.bucket, this.key) : s3Handler.existsKeyInS3(this.bucket, this.key);
        this.ctx.put(RESULT_CONTEXT_VAR_NAME, (Object)exists);
    }
}

