/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;

@Operation(id="S3Utils.TempSignedUrl", category="Files", label="S3 Utils: Temp Signed URL", description="Set the s3UtilsTempSignedUrl context variable to the temporary signed URL to the object. handler, bucket and duration are optional: If not passed, the default values apply (as set in the handler configuration)")
public class S3TempSignedUrlOp {
    public static final String ID = "S3Utils.TempSignedUrl";
    public static final String RESULT_CONTEXT_VAR_NAME = "s3UtilsTempSignedUrl";
    @Context
    protected OperationContext ctx;
    @Param(name="key", required=true)
    protected String key;
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="bucket", required=false)
    protected String bucket;
    @Param(name="durationInSeconds", required=false)
    protected Integer durationInSeconds;
    @Param(name="contentType", required=false)
    protected String contentType;
    @Param(name="contentDisposition", required=false)
    protected String contentDisposition;

    @OperationMethod
    public void run() throws NuxeoException, IOException {
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        S3Handler s3Handler = S3Handler.getS3Handler(this.handlerName);
        if (StringUtils.isNotBlank((CharSequence)this.bucket)) {
            s3Handler.setBucket(this.bucket);
        }
        if (this.durationInSeconds == null || this.durationInSeconds < 1) {
            this.durationInSeconds = s3Handler.getSignedUrlDuration();
        }
        String url = s3Handler.buildPresignedUrl(this.bucket, this.key, this.durationInSeconds, this.contentType, this.contentDisposition);
        this.ctx.put(RESULT_CONTEXT_VAR_NAME, (Object)url);
    }
}

