/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.s3utils.S3Handler;

public class CacheForKeyExists {
    protected static final int MAX_KEYS = 500;
    protected static final int DURATION_IN_CACHE_MS = 600000;
    protected String defaultBucket;
    protected int maxInCache = 500;
    protected int durationInCache = 600000;
    protected LinkedHashMap<String, Boolean> cachedKeysAndExist = new LinkedHashMap();
    protected LinkedHashMap<String, Long> cachedKeysAndSince = new LinkedHashMap();
    protected S3Handler s3Handler;

    public CacheForKeyExists(S3Handler handler) {
        this.s3Handler = handler;
        this.defaultBucket = this.s3Handler.getBucket();
    }

    public void cleanup() {
        this.cachedKeysAndExist = null;
        this.cachedKeysAndSince = null;
        this.s3Handler = null;
    }

    protected String buildCachekey(String bucket, String objectKey) {
        if (StringUtils.isBlank((CharSequence)bucket)) {
            bucket = this.defaultBucket;
        }
        return bucket + objectKey;
    }

    protected int existsKeyCheckInCache(String cacheKey) {
        Boolean exists;
        int result = -1;
        if (StringUtils.isNotBlank((CharSequence)cacheKey) && (exists = this.cachedKeysAndExist.get(cacheKey)) != null) {
            Long since = this.cachedKeysAndSince.get(cacheKey);
            long timeNow = System.currentTimeMillis();
            if (timeNow - since >= (long)this.durationInCache) {
                this.cachedKeysAndExist.remove(cacheKey);
                this.cachedKeysAndSince.remove(cacheKey);
            } else {
                result = exists != false ? 1 : 0;
            }
        }
        return result;
    }

    protected void addToCachedKeys(String cacheKey, boolean exists) {
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            if (this.cachedKeysAndExist.size() >= this.maxInCache) {
                long timeNow = System.currentTimeMillis();
                Iterator<Map.Entry<String, Long>> it = this.cachedKeysAndSince.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Long> current = it.next();
                    Long since = current.getValue();
                    if (timeNow - since < (long)this.durationInCache) continue;
                    it.remove();
                    this.cachedKeysAndExist.remove(current.getKey());
                }
                if (this.cachedKeysAndExist.size() >= this.maxInCache) {
                    int howMany = (int)((double)this.maxInCache * 0.2);
                    String[] keys = new String[howMany];
                    Iterator<Map.Entry<String, Boolean>> iterator = this.cachedKeysAndExist.entrySet().iterator();
                    for (int i = 0; i < howMany; ++i) {
                        keys[i] = iterator.next().getKey();
                    }
                    for (String oneKey : keys) {
                        this.cachedKeysAndExist.remove(oneKey);
                        this.cachedKeysAndSince.remove(oneKey);
                    }
                }
            }
            this.cachedKeysAndExist.put(cacheKey, exists);
            this.cachedKeysAndSince.put(cacheKey, System.currentTimeMillis());
        }
    }

    public boolean isInCache(String bucket, String objectKey) {
        String cacheKey = this.buildCachekey(bucket, objectKey);
        return this.existsKeyCheckInCache(cacheKey) > -1;
    }

    public boolean isInCache(String objectKey) {
        return this.isInCache(null, objectKey);
    }

    public boolean existsKey(String objectKey) {
        return this.existsKey(null, objectKey);
    }

    public boolean existsKey(String bucket, String objectKey) {
        boolean exists = false;
        if (StringUtils.isNotBlank((CharSequence)objectKey)) {
            String bucketAndKey;
            int inCache;
            if (StringUtils.isBlank((CharSequence)bucket)) {
                bucket = this.defaultBucket;
            }
            if ((inCache = this.existsKeyCheckInCache(bucketAndKey = this.buildCachekey(bucket, objectKey))) != -1) {
                exists = inCache == 1;
            } else {
                this.s3Handler.setBucket(bucket);
                exists = this.s3Handler.existsKeyInS3(objectKey);
                this.addToCachedKeys(bucketAndKey, exists);
            }
        }
        return exists;
    }

    public int getCacheCount() {
        return this.cachedKeysAndExist.size();
    }

    public void setBucket(String inBucket) {
        this.defaultBucket = StringUtils.isBlank((CharSequence)inBucket) ? this.s3Handler.getBucket() : inBucket;
    }

    public int getMaxInCache() {
        return this.maxInCache;
    }

    public void setMaxInCache(int maxInCache) {
        this.maxInCache = maxInCache <= 0 ? 500 : maxInCache;
    }

    public int getDurationInCache() {
        return this.durationInCache;
    }

    public void setDurationInCache(int durationInCacheMillisecs) {
        this.durationInCache = durationInCacheMillisecs <= 0 ? 600000 : durationInCacheMillisecs;
    }
}

