/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;
import org.nuxeo.s3utils.CacheForKeyExists;
import org.nuxeo.s3utils.S3Handler;
import org.nuxeo.s3utils.S3HandlerDescriptor;
import org.nuxeo.s3utils.S3ObjectSequentialStream;

public class S3HandlerImpl
implements S3Handler {
    protected static final Log log = LogFactory.getLog(S3HandlerImpl.class);
    protected String name;
    protected String region;
    protected String currentBucket;
    protected int signedUrlDuration;
    protected boolean useCacheForExistsKey;
    protected AmazonS3 s3;
    protected TransferManager transferManager;
    protected CacheForKeyExists keyExistsCache = null;
    protected long minimumUploadPartSize;
    long multipartUploadThreshold;

    @Override
    public void initialize(S3HandlerDescriptor desc) throws NuxeoException {
        this.name = desc.getName();
        this.region = desc.getRegion();
        this.currentBucket = desc.getBucket();
        this.signedUrlDuration = desc.getTempSignedUrlDuration();
        this.useCacheForExistsKey = desc.useCacheForExistsKey();
        this.minimumUploadPartSize = desc.getMinimumUploadPartSize();
        this.multipartUploadThreshold = desc.getMultipartUploadThreshold();
        this.setup(desc);
    }

    protected void setup(S3HandlerDescriptor desc) {
        AWSCredentialsProvider awsCredentialsProvider = NuxeoAWSCredentialsProvider.getInstance();
        this.s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(this.region)).build();
        this.transferManager = TransferManagerBuilder.standard().withS3Client(this.s3).withMinimumUploadPartSize(Long.valueOf(this.minimumUploadPartSize)).withMultipartUploadThreshold(Long.valueOf(this.multipartUploadThreshold)).withAlwaysCalculateMultipartMd5(true).build();
        if (this.useCacheForExistsKey) {
            this.keyExistsCache = new CacheForKeyExists(this);
        }
    }

    @Override
    public void cleanup() {
        if (this.keyExistsCache != null) {
            this.keyExistsCache.cleanup();
            this.keyExistsCache = null;
        }
    }

    @Override
    public boolean sendFile(String inKey, File inFile) throws NuxeoException {
        boolean ok = false;
        try {
            Upload upload = this.transferManager.upload(this.currentBucket, inKey, inFile);
            upload.waitForCompletion();
            ok = true;
        }
        catch (AmazonServiceException ase) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ase));
            throw new NuxeoException(message);
        }
        catch (AmazonClientException ace) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ace));
            throw new NuxeoException(message);
        }
        catch (InterruptedException ie) {
            String message = S3Handler.buildDetailedMessageFromAWSException(ie);
            throw new NuxeoException(message);
        }
        return ok;
    }

    @Override
    public Blob downloadFile(String inKey, File inDestFile) {
        ObjectMetadata metadata = null;
        try {
            GetObjectRequest gor = new GetObjectRequest(this.currentBucket, inKey);
            Download download = this.transferManager.download(gor, inDestFile);
            download.waitForCompletion();
            metadata = download.getObjectMetadata();
        }
        catch (AmazonServiceException ase) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ase));
            throw new NuxeoException(message);
        }
        catch (AmazonClientException ace) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ace));
            throw new NuxeoException(message);
        }
        catch (InterruptedException ie) {
            String message = S3Handler.buildDetailedMessageFromAWSException(ie);
            throw new NuxeoException(message);
        }
        FileBlob blob = new FileBlob(inDestFile);
        blob.setDigest(metadata.getETag());
        blob.setEncoding(metadata.getContentEncoding());
        blob.setFilename(inDestFile.getName());
        blob.setMimeType(metadata.getContentType());
        return blob;
    }

    @Override
    public SequenceInputStream getSequenceInputStream(String inKey, long pieceSize) throws IOException {
        S3ObjectSequentialStream seqStream = new S3ObjectSequentialStream(this.s3, this.currentBucket, inKey, pieceSize);
        return seqStream.getInputStream();
    }

    @Override
    public byte[] readBytes(String key, long start, long len) throws IOException {
        GetObjectRequest gor = new GetObjectRequest(this.currentBucket, key).withRange(start, start + len - 1L);
        S3ObjectInputStream stream = this.s3.getObject(gor).getObjectContent();
        byte[] bytes = stream.readAllBytes();
        stream.close();
        return bytes;
    }

    @Override
    public Blob downloadFile(String inKey, String inFileName) throws NuxeoException {
        Blob blob;
        try {
            blob = Blobs.createBlobWithExtension((String)".tmp");
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        blob = this.downloadFile(inKey, blob.getFile());
        if (StringUtils.isBlank((CharSequence)inFileName)) {
            inFileName = FilenameUtils.getName((String)inKey);
        }
        blob.setFilename(inFileName);
        return blob;
    }

    @Override
    public boolean deleteFile(String inKey) throws NuxeoException {
        boolean ok = false;
        try {
            this.s3.deleteObject(this.currentBucket, inKey);
            ok = true;
        }
        catch (AmazonServiceException ase) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ase));
            throw new NuxeoException(message);
        }
        catch (AmazonClientException ace) {
            String message = S3Handler.buildDetailedMessageFromAWSException((Exception)((Object)ace));
            throw new NuxeoException(message);
        }
        return ok;
    }

    @Override
    public String buildPresignedUrl(String inBucket, String inKey, int durationInSeconds, String contentType, String contentDisposition) throws NuxeoException {
        if (StringUtils.isBlank((CharSequence)inBucket)) {
            inBucket = this.currentBucket;
        }
        if (StringUtils.isBlank((CharSequence)inBucket)) {
            throw new NuxeoException("No bucket provided");
        }
        if (durationInSeconds <= 0) {
            durationInSeconds = this.signedUrlDuration;
        }
        if (durationInSeconds <= 0) {
            throw new IllegalArgumentException("duration of " + durationInSeconds + " is invalid.");
        }
        Date expiration = new Date();
        expiration.setTime(expiration.getTime() + (long)(durationInSeconds * 1000));
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.currentBucket, inKey, HttpMethod.GET);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            request.addRequestParameter("response-content-type", contentType);
        }
        if (StringUtils.isNotBlank((CharSequence)contentDisposition)) {
            request.addRequestParameter("response-content-disposition", contentDisposition);
        }
        request.setExpiration(expiration);
        URL url = this.s3.generatePresignedUrl(request);
        try {
            URI uri = url.toURI();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String buildPresignedUrl(String inKey, int durationInSeconds, String contentType, String contentDisposition) throws NuxeoException {
        return this.buildPresignedUrl(null, inKey, durationInSeconds, contentType, contentDisposition);
    }

    @Override
    public boolean existsKeyInS3(String inBucket, String inKey) {
        boolean exists;
        block3: {
            exists = false;
            if (StringUtils.isBlank((CharSequence)inBucket)) {
                inBucket = this.currentBucket;
            }
            try {
                ObjectMetadata metadata = this.s3.getObjectMetadata(inBucket, inKey);
                exists = true;
            }
            catch (AmazonClientException e) {
                if (S3Handler.errorIsMissingKey(e)) break block3;
                exists = true;
            }
        }
        return exists;
    }

    @Override
    public boolean existsKeyInS3(String inKey) {
        return this.existsKeyInS3(null, inKey);
    }

    @Override
    public boolean existsKey(String inKey) {
        return this.existsKey(null, inKey);
    }

    @Override
    public boolean existsKey(String inBucket, String inKey) {
        if (StringUtils.isBlank((CharSequence)inBucket)) {
            inBucket = this.currentBucket;
        }
        if (this.keyExistsCache != null) {
            return this.keyExistsCache.existsKey(inBucket, inKey);
        }
        return this.existsKeyInS3(inBucket, inKey);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String inKey) {
        ObjectMetadata metadata;
        try {
            metadata = this.s3.getObjectMetadata(this.currentBucket, inKey);
        }
        catch (AmazonS3Exception e) {
            throw new NuxeoException(String.format("An error occured while getting key %s in AWS bucket %s", inKey, this.currentBucket), (Throwable)e);
        }
        return metadata;
    }

    @Override
    public JsonNode getObjectMetadataJson(String inKey) throws JsonProcessingException {
        ObjectMetadata metadata = this.getObjectMetadata(inKey);
        Map metadataMap = metadata.getRawMetadata();
        HashMap<String, Object> mutableMap = new HashMap<String, Object>(metadataMap);
        mutableMap.put("bucketName", this.currentBucket);
        mutableMap.put("objectKey", inKey);
        Map userMetadata = metadata.getUserMetadata();
        mutableMap.put("userMetadata", userMetadata);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode json = objectMapper.valueToTree(mutableMap);
        return json;
    }

    @Override
    public void setBucket(String inBucket) {
        this.currentBucket = inBucket;
        if (this.keyExistsCache != null) {
            this.keyExistsCache.setBucket(inBucket);
        }
    }

    @Override
    public AmazonS3 getS3() {
        return this.s3;
    }

    @Override
    public String getBucket() {
        return this.currentBucket;
    }

    @Override
    public int getSignedUrlDuration() {
        return this.signedUrlDuration;
    }
}

