/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.s3utils.S3UtilsBlobProvider;

@Operation(id="S3Utils.CreateBlobFromObjectKey", category="Files", label="S3 Utils: Create Blob from Object Key", description="Expects as required parameters a providerId (a provider that uses the org.nuxeo.s3utils.S3UtilsBlobProvider class) and the key of an object in S3. Returns a blob that references this object.<br>Cf. the documentation: the BlobProvider is linked to a S3Handler that knows which bucket to use.")
public class S3BlobProviderCreateBlobForObjectKeyOp {
    public static final String ID = "S3Utils.CreateBlobFromObjectKey";
    @Context
    BlobManager blobManager;
    @Param(name="blobProviderId", required=true)
    protected String blobProviderId;
    @Param(name="objectKey", required=true)
    protected String objectKey;

    @OperationMethod
    public Blob run() throws IOException {
        S3UtilsBlobProvider blobProvider = (S3UtilsBlobProvider)this.blobManager.getBlobProvider(this.blobProviderId);
        if (blobProvider == null) {
            throw new NuxeoException("The S3UtilsBlobProvider with id '" + this.blobProviderId + "' is not found. Did you contribute it in your XML?");
        }
        ManagedBlob b = blobProvider.createBlobFromObjectKey(this.objectKey);
        return b;
    }
}

