/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.s3utils.operations;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.s3utils.S3Handler;

@Operation(id="S3Utils.GetObjectMetadata", category="Files", label="S3 Utils: Get Object Metadata", description="Returns a JsonBlob with the object metadata, using S3Handler <code>handlerName</code> (if empty, uses the default handler). Uses the bucket set in the handler configuration. The returned JSON contains all the AWS metadata system fields, and the 'bucket', 'key' and 'userMetadata' properties. The later is a Json object (can be empty) holding all the user metadata for the object. If the object is  ot found (does not exist or current roel can't access it), returns an empty object {}")
public class S3GetObjectMetadataOp {
    public static final String ID = "S3Utils.GetObjectMetadata";
    @Context
    protected OperationContext ctx;
    @Param(name="handlerName", required=false, values={"default"})
    protected String handlerName;
    @Param(name="key", required=true)
    protected String key;

    @OperationMethod
    public Blob run() throws NuxeoException, IOException {
        if (StringUtils.isBlank((CharSequence)this.handlerName)) {
            this.handlerName = "default";
        }
        S3Handler s3Handler = S3Handler.getS3Handler(this.handlerName);
        JsonNode json = null;
        try {
            json = s3Handler.getObjectMetadataJson(this.key);
        }
        catch (NuxeoException nuxeoException) {
            // empty catch block
        }
        if (json == null) {
            return Blobs.createJSONBlob((String)"{}");
        }
        return Blobs.createJSONBlob((String)json.toString());
    }
}

