/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.project.sample;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.project.sample.BookManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="bookManager")
public class BookManagerBean
implements BookManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BookManagerBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    private String firstName;
    private String lastName;
    private String isbn;
    private List<String> keywords;
    protected List<SelectItem> keywordList;
    private String page;
    private int rating;
    private String filter;
    private static Random rand = new Random();
    protected static String[] FIRSTNAMES = new String[]{"Steve", "John", "Raoul", "James"};
    protected static String[] LASTNAMES = new String[]{"Bond", "Einstein", "Tanaka", "Presley"};

    @Override
    public String getParentTitle() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        DocumentModel parent = this.documentManager.getParentDocument(doc.getRef());
        return (String)parent.getProperty("dublincore", "title");
    }

    @Override
    public String getFirstName() {
        if (this.firstName == null) {
            this.firstName = "";
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String s) {
        this.firstName = s;
    }

    @Override
    public String getLastName() {
        if (this.lastName == null) {
            this.lastName = "";
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String s) {
        this.lastName = s;
    }

    @Override
    public String getIsbn() {
        if (this.isbn == null) {
            return "";
        }
        return this.isbn;
    }

    @Override
    public void setIsbn(String s) {
        this.isbn = s;
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public List<SelectItem> getAvailableKeywords() {
        if (this.keywordList == null) {
            this.computeKeywordValues();
        }
        return this.keywordList;
    }

    @Override
    @Observer(value={"documentSelectionChanged"}, create=false)
    public void resetKeywordValues() {
        this.keywordList = null;
    }

    private void computeKeywordValues() {
        DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try (Session dir = dirService.open("book_keywords");){
            DocumentModelList entries = dir.getEntries();
            this.keywordList = new ArrayList<SelectItem>(entries.size());
            for (DocumentModel e : entries) {
                String value = (String)e.getProperty("vocabulary", "id");
                String label = (String)e.getProperty("vocabulary", "label");
                SelectItem item = new SelectItem((Object)value, label);
                this.keywordList.add(item);
            }
        }
    }

    @Override
    public void randomFirstName() {
        this.firstName = FIRSTNAMES[rand.nextInt(FIRSTNAMES.length)];
    }

    @Override
    public void randomLastName() {
        this.lastName = LASTNAMES[rand.nextInt(LASTNAMES.length)];
    }

    @Override
    public void changeData() {
        if (this.getFirstName().equals(this.getLastName())) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "First name and last name must be different", new Object[0]);
        }
        DocumentModel document = this.navigationContext.getCurrentDocument();
        String title = this.getFirstName() + " " + this.getLastName();
        document.setProperty("dublincore", "title", (Object)title);
        document.setProperty("book", "rating", (Object)this.rating);
        document.setProperty("book", "keywords", this.keywords);
        this.documentManager.saveDocument(document);
        this.documentManager.save();
    }

    @Override
    public void validation(FacesContext context, UIComponent component, Object value) {
        Integer v = (Integer)value;
        if (v % 2 != 0) {
            ((EditableValueHolder)component).setValid(false);
            FacesMessage message = new FacesMessage();
            message.setDetail("The value must be a multiple of 2");
            message.setSummary("Not a multiple of 2");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            this.facesMessages.add(component.getId(), new Object[]{message});
        }
    }

    @Override
    public DocumentModelList getSearchResults() {
        DocumentModelList result = this.documentManager.query("SELECT * FROM Book", 10);
        return result;
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String newfilter) {
        if (this.filter == null || !this.filter.equals(newfilter)) {
            // empty if block
        }
        this.filter = newfilter;
    }

    @Override
    @WebRemote
    public String something(String param) {
        return "It worked: " + param;
    }

    @Override
    public String toWizardPage(String page) {
        this.page = page;
        return "bookwizard";
    }

    @Override
    public String getWizardPage() {
        return "/incl/bookwizard_page" + this.page + ".xhtml";
    }

    @Override
    public String validateWizard() {
        DocumentModel document = this.navigationContext.getChangeableDocument();
        String title = this.getFirstName() + " " + this.getLastName();
        document.setProperty("dublincore", "title", (Object)title);
        document.setProperty("book", "isbn", (Object)this.isbn);
        this.documentManager.saveDocument(document);
        this.documentManager.save();
        return this.webActions.setCurrentTabAndNavigate("TAB_VIEW");
    }

    @Override
    public List<BookInfo> getBooksInFolder() {
        LinkedList<BookInfo> list = new LinkedList<BookInfo>();
        DocumentModel folder = this.navigationContext.getCurrentDocument();
        DocumentModelList children = this.documentManager.getChildren(folder.getRef(), "Book");
        for (DocumentModel doc : children) {
            String[] keywords = (String[])doc.getProperty("book", "keywords");
            if (keywords == null) continue;
            list.add(new BookInfo(doc, Arrays.asList(keywords)));
        }
        return list;
    }

    @Override
    public String duplicateSiblings() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        DocumentModel folder = this.documentManager.getParentDocument(doc.getRef());
        DocumentModel gp = this.documentManager.getParentDocument(folder.getRef());
        HashSet<String> names = new HashSet<String>();
        for (DocumentModel f : this.documentManager.getChildren(gp.getRef())) {
            names.add(f.getName());
        }
        String newFolderName = folder.getName();
        while (names.contains(newFolderName)) {
            newFolderName = newFolderName + "copy";
        }
        DocumentModel newFolder = this.documentManager.createDocumentModel(gp.getPathAsString(), newFolderName, folder.getType());
        newFolder.setProperty("dublincore", "title", (Object)"Nouveau folder");
        this.documentManager.createDocument(newFolder);
        String newFolderPath = newFolder.getPathAsString();
        for (DocumentModel child : this.documentManager.getChildren(folder.getRef(), "Book")) {
            DocumentModel newChild = this.documentManager.createDocumentModel(newFolderPath, child.getName(), "Note");
            String title = child.getProperty("dublincore", "title") + " duplicated";
            newChild.setProperty("dublincore", "title", (Object)title);
            this.documentManager.createDocument(newChild);
        }
        this.documentManager.save();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{gp});
        return null;
    }

    public String getContainerPath() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.getDocumentType().getName().equals("Book")) {
            return currentDocument.getPath().removeLastSegments(1).toString();
        }
        return currentDocument.getPathAsString();
    }

    public static class BookInfo {
        private DocumentModel doc;
        private List<String> labels;

        public BookInfo(DocumentModel doc, List<String> labels) {
            this.doc = doc;
            this.labels = labels;
        }

        public DocumentModel getDocument() {
            return this.doc;
        }

        public List<String> getLabels() {
            return this.labels;
        }
    }
}

