/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.ecm.versions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="esupversions")
@WebObject(type="esupversions")
public class Main
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(Main.class);
    protected File zipDirectory;
    protected boolean isRoot = true;
    protected String child;
    protected Object requestedObject;

    @GET
    public Object doGet() {
        if (this.requestedObject == null) {
            return this.getView("index");
        }
        return this.requestedObject;
    }

    protected void resolve(String versionUid) throws ClientException {
        IdRef docRef = new IdRef(versionUid);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel doc = session.getLastDocumentVersion((DocumentRef)docRef);
        if (doc == null) {
            doc = session.getDocument((DocumentRef)docRef);
        }
        if (doc.isDownloadable()) {
            this.proceedDownloadable(versionUid, doc);
        }
        if (doc.hasSchema("note")) {
            this.procedNote(versionUid, doc);
        }
    }

    private void proceedDownloadable(String versionUid, DocumentModel doc) throws ClientException {
        Property propertyFile;
        if (this.child != null) {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            for (Blob blob : bh.getBlobs()) {
                if (!blob.getFilename().contains(this.child)) continue;
                this.proceedBlob(versionUid, blob, blob.getFilename());
                return;
            }
        }
        if ((propertyFile = doc.getProperty("file:content")) != null) {
            Blob requestedBlob = (Blob)propertyFile.getValue();
            String requestedFilename = requestedBlob.getFilename();
            if (requestedFilename == null) {
                requestedFilename = this.resolveComplexFilename(propertyFile.getParent(), requestedFilename);
            }
            this.proceedBlob(versionUid, requestedBlob, requestedFilename);
        }
    }

    protected String resolveComplexFilename(Property propertyFile, String requestedFilename) {
        if (propertyFile.isComplex()) {
            try {
                requestedFilename = (String)((Object)propertyFile.getValue("filename"));
                log.debug((Object)("resolve :: requestedFilename=" + requestedFilename));
            }
            catch (PropertyException e) {
                requestedFilename = "Unknown";
            }
        }
        return requestedFilename;
    }

    protected void proceedBlob(String versionUid, Blob requestedBlob, String requestedFilename) {
        if (requestedBlob == null) {
            throw new WebResourceNotFoundException("No attached file at file:content");
        }
        log.debug((Object)("resolve :: requestedFilename=" + requestedFilename));
        this.requestedObject = Response.ok((Object)requestedBlob).header("Content-Disposition", (Object)("inline; filename=" + requestedFilename)).type(requestedBlob.getMimeType()).build();
        if (requestedFilename.endsWith(".zip")) {
            try {
                String tempdir = System.getProperty("java.io.tmpdir");
                log.debug((Object)("resolve :: tempdir=" + tempdir));
                File zipFile = new File(tempdir, "nuxeo-esup-webengine-" + versionUid + ".zip");
                this.zipDirectory = new File(tempdir, "nuxeo-esup-webengine-" + versionUid);
                if (!this.zipDirectory.exists()) {
                    int len;
                    InputStream inputStream = requestedBlob.getStream();
                    FileOutputStream out = new FileOutputStream(zipFile);
                    byte[] buf = new byte[1024];
                    while ((len = inputStream.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    inputStream.close();
                    de.schlichtherle.io.File trueZipFile = new de.schlichtherle.io.File(zipFile);
                    trueZipFile.copyAllTo(this.zipDirectory);
                }
                File[] files = this.zipDirectory.listFiles();
                Object requestedObjectTemp = null;
                if (files != null && files.length == 1 && files[0].isDirectory()) {
                    log.debug((Object)("resolve :: one directory element :: " + files[0].getName()));
                    requestedObjectTemp = this.getRequestedObjectFromFiles(versionUid, files[0].getName(), files[0].listFiles());
                } else {
                    log.debug((Object)"resolve :: files elements");
                    requestedObjectTemp = this.getRequestedObjectFromFiles(versionUid, null, files);
                }
                if (requestedObjectTemp != null) {
                    this.requestedObject = requestedObjectTemp;
                }
            }
            catch (Exception ie) {
                log.error((Object)("problem unziping zip file from document version :" + versionUid), (Throwable)ie);
            }
        }
    }

    private void procedNote(String versionUid, DocumentModel doc) throws PropertyException, ClientException {
        String requestedFilename = null;
        String requestedContent = null;
        String requestedMimeType = null;
        Property property = null;
        property = doc.getProperty("dublincore:title");
        if (property != null) {
            requestedFilename = property.getValue() + ".txt";
        }
        if ((property = doc.getProperty("note:note")) != null) {
            requestedContent = (String)((Object)property.getValue());
        }
        if ((property = doc.getProperty("note:mime_type")) != null && (requestedMimeType = (String)((Object)property.getValue())) == null) {
            requestedMimeType = "text/plain";
        }
        if (requestedFilename != null && requestedContent != null && requestedMimeType != null) {
            this.requestedObject = Response.ok((Object)requestedContent).header("Content-Disposition", (Object)("inline; filename=" + requestedFilename)).type(requestedMimeType).build();
        }
    }

    private Object getRequestedObjectFromFiles(String versionUid, String directoryName, File[] files) {
        boolean indexHtml = false;
        boolean indexHtm = false;
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.equals("index.html")) {
                indexHtml = true;
            }
            if (!fileName.equals("index.htm")) continue;
            indexHtm = true;
        }
        log.debug((Object)("getRequestedObjectFromFiles :: indexHtml=" + indexHtml));
        log.debug((Object)("getRequestedObjectFromFiles :: indexHtm=" + indexHtm));
        if (indexHtml) {
            return this.getRequestedObjectFromFileName(versionUid, directoryName, "index.html");
        }
        if (indexHtm) {
            return this.getRequestedObjectFromFileName(versionUid, directoryName, "index.htm");
        }
        return null;
    }

    private Object getRequestedObjectFromFileName(String versionUid, String directoryName, String fileName) {
        String ctxUrlPath = this.getPath();
        ctxUrlPath = ctxUrlPath.endsWith("/") ? ctxUrlPath : ctxUrlPath + "/";
        ctxUrlPath = ctxUrlPath + versionUid;
        log.debug((Object)("getRequestedObjectFromFileName :: ctxUrlPath=" + ctxUrlPath));
        String indexUrl = ctxUrlPath.endsWith("/") ? ctxUrlPath : ctxUrlPath + "/";
        indexUrl = directoryName != null ? indexUrl + directoryName + "/" : indexUrl;
        indexUrl = indexUrl + fileName;
        log.debug((Object)("getRequestedObjectFromFileName :: indexUrl=" + indexUrl));
        return this.redirect(indexUrl);
    }

    @GET
    @Path(value="defaultWebengineSkin/{path:.*}")
    public Response getSkinResource(@PathParam(value="path") String path) {
        return super.getSkinResource(path);
    }

    @Path(value="{path}")
    public Object traverse(@PathParam(value="path") String path) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        String errorMessage = "";
        log.debug((Object)("traverse :: isRoot=" + this.isRoot));
        log.debug((Object)("traverse :: path=" + path));
        if (this.isRoot) {
            this.isRoot = false;
            String versionUid = path;
            log.debug((Object)("traverse :: versionUid=" + versionUid));
            try {
                this.resolve(versionUid);
                return this;
            }
            catch (DocumentSecurityException se) {
                NuxeoPrincipal user = (NuxeoPrincipal)session.getPrincipal();
                if (user.isAnonymous()) {
                    Response.ResponseBuilder responseBuilder;
                    String localName = this.ctx.getRequest().getLocalName();
                    StringBuffer domain = new StringBuffer();
                    String[] localName_element = localName.split("\\.");
                    for (int i = 1; i < localName_element.length; ++i) {
                        domain.append(".").append(localName_element[i]);
                    }
                    String requestPage = this.getPath().replaceFirst("/nuxeo/", "") + this.getTrailingPath();
                    NewCookie cookieUrlToReach = new NewCookie("sso.initial.url.request", requestPage, "/", domain.toString(), 1, "sso.initial.url.request", 60, false);
                    String url = this.ctx.getServerURL().append("/nuxeo/logout").toString();
                    try {
                        responseBuilder = Response.seeOther((URI)new URI(url));
                    }
                    catch (URISyntaxException e) {
                        throw WebException.wrap((Throwable)e);
                    }
                    responseBuilder.cookie(new NewCookie[]{cookieUrlToReach});
                    this.requestedObject = responseBuilder.build();
                    return this;
                }
                errorMessage = se.getMessage();
            }
            catch (ClientException ce) {
                log.error((Object)"Version document can't be viewed", (Throwable)ce);
                errorMessage = ce.getMessage();
            }
            this.requestedObject = this.getView("index").arg("versionUid", (Object)path).arg("error", (Object)("Version document can't be accessed : " + errorMessage));
        } else if (this.zipDirectory != null) {
            final String filePath = path;
            log.debug((Object)("traverse :: filePath=" + filePath));
            List<String> files = Arrays.asList(this.zipDirectory.list());
            log.debug((Object)("traverse :: files=" + files));
            if (files.contains(filePath)) {
                log.debug((Object)"traverse :: files.contains == OK");
                FilenameFilter filterNameIndex = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(filePath);
                    }
                };
                File requestedFile = this.zipDirectory.listFiles(filterNameIndex)[0];
                log.debug((Object)("traverse :: requestedFile=" + requestedFile));
                if (requestedFile.isDirectory()) {
                    this.zipDirectory = requestedFile;
                } else {
                    FileBlob requestedBlob = new FileBlob(requestedFile);
                    String requestedFilename = filePath;
                    log.debug((Object)("traverse :: requestedFilename=" + requestedFilename));
                    Response.ResponseBuilder responseBuilder = Response.ok((Object)requestedBlob);
                    responseBuilder = responseBuilder.header("Content-Disposition", (Object)("inline; filename=" + requestedFilename)).type(requestedBlob.getMimeType());
                    responseBuilder = responseBuilder.type(this.getMimetype(requestedFilename, (Blob)requestedBlob));
                    this.requestedObject = responseBuilder.build();
                }
            }
        }
        return this;
    }

    @GET
    @Path(value="{uid}/file/{child}/preview")
    public Object redirecToPreview(@PathParam(value="uid") String uid, @PathParam(value="child") String child) throws Exception {
        try {
            IdRef idRef = new IdRef(uid);
            DocumentModel doc = this.ctx.getCoreSession().getLastDocumentVersion((DocumentRef)idRef);
            if (doc == null) {
                doc = this.ctx.getCoreSession().getDocument((DocumentRef)idRef);
            }
            for (Property pro : new BlobsExtractor().getBlobsProperties(doc)) {
                Blob bl = (Blob)pro.getValue();
                if (!bl.getFilename().contains(child)) continue;
                return this.redirect(VirtualHostHelper.getBaseURL((ServletRequest)this.request) + PreviewHelper.getPreviewURL((DocumentModel)doc, (String)this.previewXPath(pro)));
            }
        }
        catch (ClientException e) {
            log.debug((Object)e);
        }
        return Response.noContent().build();
    }

    protected String previewXPath(Property property) {
        String path = property.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        path = path.replaceAll("item\\[(\\d+)\\]", "$1").replace("/", "-");
        return String.format("%s:%s", property.getSchema().getName(), path);
    }

    @Path(value="{path}/file/{child}")
    public Object traverseWithChild(@PathParam(value="path") String path, @PathParam(value="child") String child) throws Exception {
        this.child = child;
        return this.traverse(path);
    }

    private String getMimetype(String fileName, Blob blog) throws Exception {
        MimetypeRegistry mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String detectedMimeType = mimeService.getMimetypeFromFilenameAndBlobWithDefault(fileName, blog, null);
        if (fileName.endsWith(".css")) {
            detectedMimeType = "text/css";
        } else if (fileName.endsWith(".js")) {
            detectedMimeType = "application/javascript";
        }
        if (detectedMimeType == null) {
            detectedMimeType = "application/octet-stream";
        }
        return detectedMimeType;
    }
}

