/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class GuestSecurityPolicy
extends AbstractSecurityPolicy {
    protected String anonymousId = null;
    protected static List<String> PERMISSIONS = Arrays.asList("Read", "ReadChildren", "ReadVersion", "ReadLifeCycle", "Browse");

    public Access checkPermission(Document document, ACP acp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        if (!principal.getName().equals(this.anonymousId())) {
            return null;
        }
        if (!document.isVersion()) {
            return null;
        }
        return PERMISSIONS.contains(permission) ? Access.GRANT : Access.DENY;
    }

    protected String anonymousId() {
        try {
            if (this.anonymousId == null) {
                this.anonymousId = ((UserManager)Framework.getLocalService(UserManager.class)).getAnonymousUserId();
            }
            return this.anonymousId;
        }
        catch (ClientException e) {
            return null;
        }
    }
}

